package com.digiwin.athena.semc.service.common;

import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.util.thread.NamedThreadFactory;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

/**
 * @description: 数据批量提交入持久化库的业务单元
 * @author: sunyfa
 */
@Slf4j
public final class MessagePersistenceProcess {
    // 单例
    private static MessagePersistenceProcess instance = new MessagePersistenceProcess();

    private ArrayBlockingQueue<UpgradeBrowseDetail> batchBlockQueue = null;

    private MessagePersistenceProcess() {
    }

    /**
     * @description: 获取 MessagePersistenceProcess 实例
     * @param
     * @return
     * @author: sunyfa
     */
    public static MessagePersistenceProcess getInstance() {
        if (instance == null) {
            instance = new MessagePersistenceProcess();
        }
        return instance;
    }

    /**
     * @description: 初始化提交入持久化队列
     * @param
     * @return
     * @author: sunyfa
     */
    private void initQueue() {
        batchBlockQueue = new ArrayBlockingQueue<>(1000);
    }

    /**
     * @description: 提交入持久化线程到线程池
     * @param
     * @return
     * @author: sunyfa
     */
    private void startHandler() {
        ExecutorService service = new ThreadPoolExecutor(0, 1000, 60L, TimeUnit.SECONDS, new SynchronousQueue<>(),
                new NamedThreadFactory("StorageThreadPool"));

        UpgradeBrowseDetailHandler batchHandler = new UpgradeBrowseDetailHandler(batchBlockQueue);
        batchHandler.setName("storageBatch");
        service.execute(batchHandler);
    }

    /**
     * @description: 初始化队列&提交线程进线程池
     * @param
     * @return
     * @author: sunyfa
     */
    public void start() {
        initQueue();
        startHandler();
    }

    /**
     * @param data 需要异步保存的数据
     * @return
     * @description: 推消息到队列中
     * @author: sunyfa
     */
    public void pushBatch(UpgradeBrowseDetail data) {
        try {
            this.batchBlockQueue.put(data);
        } catch (InterruptedException ie) {
            log.error("message persistence process push batch error", ie);
            Thread.currentThread().interrupt();
        } catch (Exception e) {
            log.error("message persistence process push batch error", e);
        }
    }
}
