package com.digiwin.athena.semc.service.common;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.service.homepage.IUpgradeBrowseDetailService;
import com.digiwin.athena.semc.util.DateUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

@Slf4j
public class UpgradeBrowseDetailHandler extends AbstractStorageHandlerBase<UpgradeBrowseDetail> {

    private Map<String, UpgradeBrowseDetail> upgradeBrowseDetailMap = new HashMap();

    private IUpgradeBrowseDetailService upgradeBrowseDetailService = SpringUtil.getBean(IUpgradeBrowseDetailService.class);

    public UpgradeBrowseDetailHandler(ArrayBlockingQueue<UpgradeBrowseDetail> queue) {
        super(queue);
    }

    /**
     * @description: 处理队列中的数据
     * @param
     * @return
     * @author: sunyfa
     */
    @Override
    public void process(List<UpgradeBrowseDetail> tempList) {
        for (UpgradeBrowseDetail upgradeBrowseDetail : tempList) {
            processBatchStatics(upgradeBrowseDetail);
        }

        // 升级说明浏览详情批量更新
        upgradeBrowseDetailService.updateUpgradeBrowseDetail(upgradeBrowseDetailMap);

        cleanData();
    }

    /**
     * @description: 内存合并批量数据
     * @param upgradeBrowseDetail
     * @return
     * @author: sunyfa
     */
    private void processBatchStatics(UpgradeBrowseDetail upgradeBrowseDetail) {
        String key = upgradeBrowseDetail.getUserId() + ":" + upgradeBrowseDetail.getTenantId();

        if (upgradeBrowseDetailMap.containsKey(key)) {
            if (DateUtils.compare(
                    TimeUtils.parseDate(upgradeBrowseDetail.getBrowseTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                    TimeUtils.parseDate(upgradeBrowseDetailMap.get(key).getBrowseTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER)) == 2) {
                upgradeBrowseDetailMap.put(key, upgradeBrowseDetail);
            }
        } else {
            upgradeBrowseDetailMap.put(key, upgradeBrowseDetail);
        }
    }

    /**
     * @description: 清除内存中的数据
     * @param
     * @return
     * @author: sunyfa
     */
    private void cleanData() {
        upgradeBrowseDetailMap.clear();
    }
}
