package com.digiwin.athena.semc.service.common.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.common.BizObjCommonUse;
import com.digiwin.athena.semc.mapper.common.BizObjCommonUseMapper;
import com.digiwin.athena.semc.mapper.homepage.UserPoatalMapper;
import com.digiwin.athena.semc.service.common.IBizObjCommonUseService;
import com.digiwin.athena.semc.vo.common.BizObjCommonUseVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 业务对象权限关系实现类
 * @createDate: 2023/5/26 13:53
 * @author: sunyfa
 */
@Slf4j
@Service
public class BizObCommonUseServiceImpl extends ServiceImpl<BizObjCommonUseMapper, BizObjCommonUse> implements IBizObjCommonUseService {

    @Autowired
    BizObjCommonUseMapper bizObjCommonUseMapper;

    /**
     * 查询业务对象常用记录
     *
     * @param bizObjType 业务类型
     * @return
     */
    @Override
    public List<BizObjCommonUse> queryCommonUseList(Integer bizObjType) {
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        QueryWrapper<BizObjCommonUse> condition = new QueryWrapper<BizObjCommonUse>().eq("biz_obj_type", bizObjType)
                .eq("create_user_id", userId).eq("tenant_id", tenantId).orderByAsc("create_time");
        return this.bizObjCommonUseMapper.selectList(condition);
    }

    /**
     * 保存业务对象常用记录
     *
     * @param bizObjCommonUseVo 请求dto
     * @param bizObjectType     业务类型
     */
    @Override
    public void saveCommonUse(BizObjCommonUseVo bizObjCommonUseVo, int bizObjectType) {
        // 取消常用
        QueryWrapper<BizObjCommonUse> condition = new QueryWrapper<>();
        condition.eq("biz_obj_id", bizObjCommonUseVo.getPrimaryId());
        condition.eq("biz_obj_type", bizObjectType);
        condition.eq("biz_obj_sub_type", bizObjCommonUseVo.getType());
        condition.eq("create_user_id", AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        if (bizObjCommonUseVo.getCommonUseSet().equals(Boolean.FALSE)) {
            bizObjCommonUseMapper.delete(condition);
        } else { // 设置常用
            boolean exists = exists(condition);
            if (!exists) {
                BizObjCommonUse bizObjCommonUse = new BizObjCommonUse();
                bizObjCommonUse.setBizObjId(bizObjCommonUseVo.getPrimaryId());
                bizObjCommonUse.setBizObjType(bizObjectType);
                bizObjCommonUse.setBizObjSubType(bizObjCommonUseVo.getType());
                bizObjCommonUseMapper.insert(bizObjCommonUse);
            }
        }
    }

    public boolean exists(Wrapper<BizObjCommonUse> queryWrapper) {
        Long count = bizObjCommonUseMapper.selectCount(queryWrapper);
        return null != count && count > 0;
    }
}