package com.digiwin.athena.semc.service.common.impl;

import com.digiwin.athena.semc.proxy.aim.dto.TenantRouteTypeEnum;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import com.digiwin.athena.semc.service.common.EnvService;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import lombok.RequiredArgsConstructor;

@Service
@RequiredArgsConstructor
public class EnvServiceImpl implements EnvService {

    @Value("${semc.online}")
    private String semcOnline;

    private final AimService aimService;


    @Override
    public boolean isOnline() {
        return Boolean.TRUE.toString().equalsIgnoreCase(semcOnline);
    }

    @Override
    public boolean tenantIsPre() {
        return TenantRouteTypeEnum.PRE.equals(aimService.getTenantRouteTypeBySemcWeb());
    }
}
