package com.digiwin.athena.semc.service.common.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.common.ImportTemplate;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.mapper.common.ImportTemplateMapper;
import com.digiwin.athena.semc.service.common.ImportTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class ImportTemplateServiceImpl extends ServiceImpl<ImportTemplateMapper, ImportTemplate> implements ImportTemplateService {

    @Resource
    private ImportTemplateMapper importTemplateMapper;

    @Override
    public ImportTemplate getImportTemp() {
        QueryWrapper queryWrapper = new QueryWrapper<ImportTemplate>();
        List<ImportTemplate> templateList=importTemplateMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(templateList)){
            return templateList.get(0);
        }
        return null;
    }

    @Override
    public Integer saveTmp(ImportTemplate req) {
        ImportTemplate template=getImportTemp();
        if(null == template){
            return null;
        }
        if(StringUtils.isNotEmpty(req.getBenchFileId())){
            template.setBenchFileId(req.getBenchFileId());
        }
        if(StringUtils.isNotEmpty(req.getCustomFileId())){
            template.setCustomFileId(req.getCustomFileId());
        }
        if(StringUtils.isNotEmpty(req.getDataFileId())){
            template.setDataFileId(req.getDataFileId());
        }
        return importTemplateMapper.updateById(template);
    }
}
