package com.digiwin.athena.semc.service.device;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;

/**
 * @author jf gui
 */
public class DeviceBindDataWriteHandler implements SheetWriteHandler {

    private static final String CN_MSG="说明：\n" +
            "1、所有字段都必须填写\n" +
            "2、设备终端类型选择“PC，APP”二者之一的值\n" +
            "3、导入的数据都为启用数据";

    private static final String TW_MSG="說明：\n" +
            "1、所有欄位都必須填寫\n" +
            "2、設備終端類型選擇「PC，APP」二者之一的值\n" +
            "3、匯入的資料都為啟用資料";

    private static final String EN_MSG="Instructions: \n" +
            "1. All fields must be filled in\n" +
            "2. For the device terminal type, select one of the values: \"PC, APP\"\n" +
            "3. All imported data are enabled data";
    @Override
    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {

    }

    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        Locale locale = LocaleContextHolder.getLocale();
        String word = CN_MSG;
        if(Locale.TAIWAN.equals(locale)){
            word = TW_MSG;
        }else if(Locale.ENGLISH.equals(locale)){
            word = EN_MSG;
        }
        Row row0 = sheet.createRow(0);
        setRow(row0, workbook, word, (short) 2000, (short) 220, 0);
        // 合并
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
    }

    private void setRow(Row row, Workbook workbook, String word, short height, short fontHeight, int cellNum) {
        row.setHeight(height);
        Cell cell = row.createCell(cellNum);
        cell.setCellValue(word);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setWrapText(true);
        Font font = workbook.createFont();
        //设置字体
        font.setFontName("宋体");
        font.setFontHeightInPoints((short)11);
        //加粗
        //font.setBold(true);
        font.setFontHeight(fontHeight);
        //font.setColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFont(font);
        cell.setCellStyle(cellStyle);
    }
}
