package com.digiwin.athena.semc.service.device;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.device.*;
import com.digiwin.athena.semc.entity.device.UserBindDevice;

import java.util.List;

/**
 * @Author jf gui
 */
public interface IUserBindDeviceService extends IService<UserBindDevice> {

    PageInfoResp<DeviceBindRecordVO> list(DeviceBindQueryDTO request);

    DeviceBindRecordVO save(DeviceBindSaveDTO record);

    DeviceBindRecordVO update(DeviceBindUpdateDTO update);

    Boolean updateValidStatus(DeviceBindUpdateStatusDTO update);

    Boolean delete(List<Long> ids);

    List<DeviceBindExportVO> exportReport(DeviceBindExportQueryDTO req);

    List<DeviceBindRecordVO> queryUserDevice();

    void autoBind(DeviceDTO device);

    void importDeviceBind(DeviceBindImportTemplateVo deviceBindVo, AuthoredUser authoredUser);
}