package com.digiwin.athena.semc.service.device.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.tenant.TenantAttributeService;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @Author jf gui
 */
@Service
public class DeviceBindConfigServiceImpl implements IDeviceBindConfigService {

    private static final String BIND_DEVICE_CODE = "bind_device_code";

    @Resource
    private MessageSendService messageSendService;

    @Resource
    private TenantAttributeService tenantAttributeService;

    @Override
    public DeviceBindConfigDTO getConfig() {
        DeviceBindConfigDTO deviceBindConfigDTO = new DeviceBindConfigDTO();
        deviceBindConfigDTO.setBindEnabled(false);
        deviceBindConfigDTO.setBindDeviceStatus(false);
        TenantAttributeDto<Object> deviceBindConfig = tenantAttributeService.queryTenantAttributeByCode(BIND_DEVICE_CODE);
        if (Objects.nonNull(deviceBindConfig)
                && Objects.nonNull(deviceBindConfig.getAttributeValue())) {
            String configCode = (String) deviceBindConfig.getAttributeValue();
            if ("enable".equals(configCode)) {
                deviceBindConfigDTO.setBindEnabled(true);
                deviceBindConfigDTO.setBindDeviceStatus(false);
            } else if ("enableAutoBind".equals(configCode)) {
                deviceBindConfigDTO.setBindEnabled(true);
                deviceBindConfigDTO.setBindDeviceStatus(true);
            } else {
                deviceBindConfigDTO.setBindEnabled(false);
                deviceBindConfigDTO.setBindDeviceStatus(false);
            }
        }
        return deviceBindConfigDTO;
    }

    @Override
    public Boolean saveConfig(DeviceBindConfigDTO config) {
        TenantAttributeDto<Object> deviceBindConfig = tenantAttributeService.queryTenantAttributeByCode(BIND_DEVICE_CODE);
        String oldConfigCode = "notActivated";
        if (Objects.nonNull(deviceBindConfig)
                && Objects.nonNull(deviceBindConfig.getAttributeValue())) {
            oldConfigCode = (String) deviceBindConfig.getAttributeValue();
        }
        String configCode = "notActivated";
        if (BooleanUtils.isTrue(config.getBindEnabled())) {
            configCode = BooleanUtils.isTrue(config.getBindDeviceStatus()) ? "enableAutoBind" : "enable";
        }
        deviceBindConfig.setAttributeValue(configCode);
        tenantAttributeService.updateAttributeValue(deviceBindConfig);

        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        MessageDO payload = new MessageDO();
        payload.setTenantId(authoredUser.getTenantId());
        payload.setType(3);
        messageSendService.sendToClient(authoredUser.getUserId(), payload, authoredUser.getTenantId() + "/" + Constants.USER_DEVICE_CONFIG_CHANGE);
        return true;
    }
}
