package com.digiwin.athena.semc.service.device.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.device.DeviceBindSaveDTO;
import com.digiwin.athena.semc.dto.device.DeviceDTO;
import com.digiwin.athena.semc.entity.device.DeviceInfo;
import com.digiwin.athena.semc.mapper.device.DeviceInfoMapper;
import com.digiwin.athena.semc.service.device.IDeviceInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import org.springframework.stereotype.Service;

/**
 * @author jf gui
 */
@Service
public class DeviceInfoServiceImpl extends ServiceImpl<DeviceInfoMapper, DeviceInfo> implements IDeviceInfoService {

    @Override
    public DeviceInfo selectByTenantIdAndDeviceId(String deviceId) {
        return this.baseMapper.selectByTenantIdAndDeviceId(deviceId);
    }

    @Override
    public void updateDeviceInfo(long id, DeviceDTO device) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(id);
        deviceInfo.setDeviceName(device.getDeviceName());
        deviceInfo.setDeviceModel(device.getDeviceModel());
        deviceInfo.setHardwareUuid(device.getHardwareUuid());
        deviceInfo.setOsType(device.getOsType());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setMacAddress(device.getMacAddress());
        deviceInfo.setModifyTime(DateUtils.getNowTime(""));
        deviceInfo.setModifyUserId(Utils.getUserId());
        updateById(deviceInfo);
    }

    @Override
    public DeviceInfo save(DeviceDTO device) {
        String userId = Utils.getUserId();
        String tenantId = Utils.getTenantId();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceId(device.getDeviceId());
        deviceInfo.setDeviceName(device.getDeviceName());
        deviceInfo.setDeviceModel(device.getDeviceModel());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setMacAddress(device.getMacAddress());
        deviceInfo.setOsType(device.getOsType());
        deviceInfo.setSource(1);
        deviceInfo.setHardwareUuid(device.getHardwareUuid());
        deviceInfo.setCreateTime(DateUtils.getNowTime());
        deviceInfo.setCreateUserId(userId);
        deviceInfo.setModifyUserId(userId);
        deviceInfo.setTenantId(tenantId);
        save(deviceInfo);
        return deviceInfo;
    }

    @Override
    public DeviceInfo save(DeviceBindSaveDTO device) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceId(device.getDeviceId());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setOsType("Other");
        deviceInfo.setSource(0);
        deviceInfo.setTenantId(authoredUser.getTenantId());
        deviceInfo.setCreateUserId(authoredUser.getUserId());
        deviceInfo.setCreateTime(DateUtils.getNowTime());
        save(deviceInfo);
        return deviceInfo;
    }

    @Override
    public void updateDeviceTerminalType(long id, int terminalType) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(id);
        deviceInfo.setTerminalType(terminalType);
        deviceInfo.setModifyTime(DateUtils.getNowTime(""));
        deviceInfo.setModifyUserId(Utils.getUserId());
        updateById(deviceInfo);
    }

}