package com.digiwin.athena.semc.service.eai;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWEAIResult;

/**
 * EAI服务
 *
 * @author: sungq
 * @date: 2024-03-14
 */
public interface EaiService {

    /**
     * 接收异构公告
     * @param jsonObject
     * @return
     * @throws Exception
     */
    DWEAIResult receiveThirdNews(JSONObject jsonObject) throws Exception;

    /**
     * 接收异构系统消息
     *
     * @param jsonObject 请求体
     * @return
     */
    DWEAIResult receiveThirdMessage(JSONObject jsonObject) throws Exception;


    /**
     * 接收异构系统作业
     *
     * @param jsonObject 请求体
     * @return
     */
    DWEAIResult receiveThirdJob(JSONObject jsonObject) throws Exception;



    /**
     * 接收异构系统待办
     *
     * @param jsonObject 请求体
     * @return
     */
    DWEAIResult receiveThirdToDo(JSONObject jsonObject) throws Exception;


    /**
     *  通知前端待办
     * @param jsonObject
     * @return
     */
    DWEAIResult noticeThirdToDo(JSONObject jsonObject);
}
