package com.digiwin.athena.semc.service.fineReport;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportListReq;
import com.digiwin.athena.semc.dto.fineReport.SaveFineReportAuthReq;
import com.digiwin.athena.semc.entity.fineReport.FineReportAuth;

import java.util.List;

/**
 * 三方应用-帆软报表权限服务接口
 *
 * @author sunqgz
 * @since 2025-08-12
 */
public interface FineReportAuthService extends IService<FineReportAuth> {

    /**
     * 查询帆软报表列表
     *
     * @param queryFineReportListReq 请求对象
     * @return 返回
     */
    JSONObject queryFineReportList(QueryFineReportListReq queryFineReportListReq);

    /**
     * 保存权限对象关联的帆软报表
     *
     * @param saveFineReportAuthReq 请求对象
     */
    void saveFineReportAuth(SaveFineReportAuthReq saveFineReportAuthReq);

    /**
     * 查询当前用户有权限的报表
     *
     * @return 返回
     */
    List<FineReportAuth> queryFineReportAuthList();
}
