package com.digiwin.athena.semc.service.fineReport;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;

import java.util.List;

/**
 * 三方应用-帆软报表服务接口
 *
 * @author sunqgz
 * @since 2025-08-11
 */
public interface FineReportManageService extends IService<FineReportUserMapping> {

    /**
     * 保存租户的帆软参数配置
     *
     * @param fineReportConfigDTO 请求参数
     */
    void saveFineReportConfig(FineReportConfigDTO fineReportConfigDTO);

    /**
     * 保存用户映射
     * @param fineReportUserMapping 用户映射
     * @return 用户映射
     */
    FineReportUserMapping saveUserMapping(FineReportUserMapping fineReportUserMapping);

    /**
     * 查询用户映射
     * @param tenantId 租户ID
     * @param req 查询参数
     * @return 用户映射列表
     */
    ResultPageBean queryUserMappings(String tenantId, FineReportQueryReq req);

    /**
     * 删除用户映射
     * @param id 用户映射ID
     */
    void deleteUserMapping(Long id);

    /**
     * 查询当前用户映射关系
     *
     * @return 返回
     */
    FineReportUserMapping queryCurrentUserMapping();

    /**
     * 查询雅典娜用户
     */
    List<RoleDTO> queryAthenaUserList();
}
