package com.digiwin.athena.semc.service.homepage;

import com.digiwin.athena.semc.dto.homepage.AdvertisementDTO;
import com.digiwin.athena.semc.dto.homepage.ReadAdvertisementReq;
import com.digiwin.athena.semc.entity.homepage.ReadAdvertisement;

import java.util.List;

/**
 * @description 首页tbb消息通知列表
 * @author: sungqz
 * @create: 2023-8-23
 */
public interface IAdvertisementService {

    /**
     * 查询es服务获取广告列表
     *
     * @param accessToken accessToken
     * @return
     */
    List<AdvertisementDTO> queryAdListFromEs(String accessToken);

    /**
     * 新增广告阅读记录
     *
     * @param readAdvertisementReq 读取广告请求对象
     * @return
     */
    boolean insertAdReadRecord(ReadAdvertisementReq readAdvertisementReq);

    /**
     * 查询当前租户下当前用户的已读列表
     *
     * @return
     */
    List<ReadAdvertisement> queryReadList();
}