package com.digiwin.athena.semc.service.homepage;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.dto.homepage.HomeSearchReq;
import com.digiwin.athena.semc.entity.homepage.UserPortalRecord;
import net.sf.json.JSONObject;

import java.util.List;

/**
 *首页搜索
 */
public interface IHomeSearchService {

    /**
     * 根据关键词搜索
     * @param homeSearchReq 请求实体
     * @param user 租户
     * @return
     */
    List<HomeSearchDTO> searchResult(HomeSearchReq homeSearchReq, AuthoredUser user);


    /**
     * 从KBS获取文档详情
     * @param fileId
     * @return
     */
    JSONObject getKbsFileDetail(String fileId);
}