package com.digiwin.athena.semc.service.homepage;

import com.digiwin.athena.semc.dto.homepage.UpgradeInfoReminderDTO;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoDetailResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoResp;

import java.util.List;

/**
 * @description: 版更service
 * @createDate: 2023/2/10 10:02
 * @author: sunyfa
 */
public interface IUpgradeInfoService {
    /**
     * @description: 首页升级说明红点和重要版更提醒
     * @param
     * @return UpgradeInfoReminderDTO 包含升级说明和重要版更未读数量
     * @author: sunyfa
     */
    List<UpgradeInfoReminderDTO> getReminder();

    /**
     * @description: 重要版更提醒关闭
     * @param
     * @return 
     * @author: sunyfa
     */
    void closeImptReminder();

    /**
     * @description: 升级说明提醒关闭
     * @param
     * @return 
     * @author: sunyfa
     */
    void closeUpgradeReminder();

    /**
     * @description: 查询版更系统详情
     * @param upgradeInfoId 版更信息Id
     * @return 版更详情
     * @author: sunyfa
     */
    UpgradeInfoDetailResp queryUpgradeDetail(String upgradeInfoId);

    /**
     * 查询版更列表
     *
     * @return
     */
    List<UpgradeInfoResp> queryUpgradeInfoList();

    /**
     * 升级说明强提醒关闭
     */
    void closeUpgradeStrongReminder();
}