package com.digiwin.athena.semc.service.homepage.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.homepage.BackGroundLogo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.homepage.BackGroundLogoMapper;
import com.digiwin.athena.semc.service.homepage.IBackGroundLogoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class BackGroundLogoServiceImpl implements IBackGroundLogoService {

    @Autowired
    private BackGroundLogoMapper backGroundLogoMapper;

    @Resource
    private EnvProperties envProperties;

    @Override
    public BackGroundLogo getBackGroundLogo() {
        QueryWrapper queryWrapper = new QueryWrapper<BackGroundLogo>();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        queryWrapper.eq("tenant_id", tenantId);
        List<BackGroundLogo> backGroundLogoList = backGroundLogoMapper.selectList(queryWrapper);
        BackGroundLogo backGroundLogo = new BackGroundLogo();
        if (CollectionUtils.isEmpty(backGroundLogoList)) {
            return backGroundLogo;
        }
        backGroundLogo = backGroundLogoList.get(0);
        //默认给模板库地址
        String logoFileUrl = backGroundLogo.getPicUrl();
        //拼接图片地址
        if (StringUtils.isNotEmpty(backGroundLogo.getPicUrl())) {
            backGroundLogo.setPicId(backGroundLogo.getPicUrl());
            logoFileUrl = StringUtils.isEmpty(backGroundLogo.getPicUrl()) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + backGroundLogo.getPicUrl();
            backGroundLogo.setPicUrl(logoFileUrl);
        }
        return backGroundLogo;
    }

    @Override
    @Transactional
    public BackGroundLogo saveBackGroundLogo(BackGroundLogo req) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //先删除该租户的背景图
        QueryWrapper queryWrapper = new QueryWrapper<BackGroundLogo>();
        queryWrapper.eq("tenant_id", tenantId);
        backGroundLogoMapper.delete(queryWrapper);
        req.setTenantId(tenantId);
        req.setPicUrlTw(req.getPicUrl());
        req.setPicUrlUs(req.getPicUrl());
        backGroundLogoMapper.insert(req);
        //拼接图片地址
        if (StringUtils.isNotEmpty(req.getPicUrl())) {
            req.setPicId(req.getPicUrl());
            String logoFileUrl = StringUtils.isEmpty(req.getPicUrl()) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + req.getPicUrl();
            req.setPicUrl(logoFileUrl);
        }
        return req;
    }
}
