package com.digiwin.athena.semc.service.homepage.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.homepage.SaveTenantPortalReq;
import com.digiwin.athena.semc.entity.homepage.TenantPortalRecord;
import com.digiwin.athena.semc.mapper.homepage.TenantPortalRecordMapper;
import com.digiwin.athena.semc.service.homepage.TenantPortalRecordService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 租户门户类型表(TenantPortalRecord)表服务实现类
 *
 * @author sungqz
 * @since 2024-05-24
 */
@Service
public class TenantPortalRecordServiceImpl extends ServiceImpl<TenantPortalRecordMapper, TenantPortalRecord> implements TenantPortalRecordService {

    @Resource
    private TenantPortalRecordMapper tenantPortalRecordMapper;

    /**
     * 查询当前租户的门户类型
     *
     * @return 返回
     */
    public TenantPortalRecord queryTenantPortal() {
        TenantPortalRecord tenantPortalRecord = tenantPortalRecordMapper.selectOne(Wrappers.emptyWrapper());
        if (tenantPortalRecord == null) {
            tenantPortalRecord = new TenantPortalRecord();
            tenantPortalRecord.setPortalType(Constants.PortalTypeEnum.SIMPLE.getFlag());
            tenantPortalRecord.setUseLatestFlag(Constants.USE_LATEST_FLAG_YES);
        }
        return tenantPortalRecord;
    }

    /**
     * 保存当前租户的门户类型
     *
     * @param saveTenantPortalReq 入参
     */
    public void saveTenantPortal(SaveTenantPortalReq saveTenantPortalReq) {
        TenantPortalRecord tenantPortalRecord = tenantPortalRecordMapper.selectOne(Wrappers.emptyWrapper());
        if (tenantPortalRecord == null) {
            tenantPortalRecord = new TenantPortalRecord();
            tenantPortalRecord.setPortalType(saveTenantPortalReq.getPortalType());
            tenantPortalRecord.setUseLatestFlag(saveTenantPortalReq.getUseLatestFlag());
            tenantPortalRecordMapper.insert(tenantPortalRecord);
        } else {
            tenantPortalRecord.setPortalType(saveTenantPortalReq.getPortalType());
            tenantPortalRecord.setUseLatestFlag(saveTenantPortalReq.getUseLatestFlag());
            tenantPortalRecordMapper.updateById(tenantPortalRecord);
        }
    }
}
