package com.digiwin.athena.semc.service.homepage.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.mapper.homepage.UpgradeBrowseDetailMapper;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.homepage.IUpgradeBrowseDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @description: 升级说明浏览详情 service
 * @createDate: 2023/2/10 14:12
 * @author: sunyfa
 */
@Service
public class UpgradeBrowseDetailServiceImpl extends ServiceImpl<UpgradeBrowseDetailMapper, UpgradeBrowseDetail> implements IUpgradeBrowseDetailService {
    @Override
    public void updateUpgradeBrowseDetail(Map<String, UpgradeBrowseDetail> upgradeBrowseDetailMap) {
        RedisLock redisLock = new RedisLock("UpgradeBrowseDetail");

        try {
            // 开启分布式锁
            redisLock.lock();

            for (Map.Entry<String, UpgradeBrowseDetail> entry : upgradeBrowseDetailMap.entrySet()) {
                UpgradeBrowseDetail upgradeBrowseDetail = entry.getValue();

                List<UpgradeBrowseDetail> upgradeBrowseDetailList = this.list(new QueryWrapper<UpgradeBrowseDetail>()
                        .eq("user_id", upgradeBrowseDetail.getUserId())
                        .eq("tenant_id", upgradeBrowseDetail.getTenantId())
                        .eq("browse_type", upgradeBrowseDetail.getBrowseType()));

                if (CollectionUtils.isNotEmpty(upgradeBrowseDetailList)) {
                    upgradeBrowseDetail.setId(upgradeBrowseDetailList.get(0).getId());
                    updateById(upgradeBrowseDetail);
                } else {
                    upgradeBrowseDetail.setId(SnowflakeIdWorker.getInstance().newId());
                    save(upgradeBrowseDetail);
                }
            }
        } catch (Exception e) {
            log.error("UpgradeBrowseDetailServiceImpl updateUpgradeBrowseDetail error", e);
        } finally {
            redisLock.unlock();
        }
    }
}
