package com.digiwin.athena.semc.service.homepage.impl;


import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.UpgradePriorityEnum;
import com.digiwin.athena.semc.common.enums.UpgradeTypeEnum;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoDTO;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoReminderDTO;
import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.entity.homepage.UpgradeReadDetail;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.proxy.gmc.service.IGmcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.cache.impl.CacheServiceImpl;
import com.digiwin.athena.semc.service.homepage.IUpgradeBrowseDetailService;
import com.digiwin.athena.semc.service.homepage.IUpgradeInfoService;
import com.digiwin.athena.semc.service.homepage.IUpgradeReadDetailService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoDetailResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoVO;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;


/**
 * @description: 版更服务
 * @createDate: 2023/2/10 13:10
 * @author: sunyfa
 */
@Slf4j
@Service
public class UpgradeInfoServiceImpl implements IUpgradeInfoService {

    @Resource
    private ICacheService cacheService;

    @Resource
    private IGmcService gmcService;

    @Resource
    private DmcService dmcService;

    @Resource
    private CacService cacService;

    @Resource
    private TranslateService translateService;

    @Resource
    private IUpgradeReadDetailService upgradeReadDetailService;

    @Resource
    private IUpgradeBrowseDetailService upgradeBrowseDetailService;

    @Resource
    private EnvProperties envProperties;

    /**
     * 文件预览地址
     */
    private static final String DMC_FILE_PREVIEW_PATH = "/api/dmc/v2/file/intelligententry/preview/";

    /**
     * 红点/悬浮框查询
     *
     * @return 返回
     */
    @Override
    public List<UpgradeInfoReminderDTO> getReminder() {
        // 获取gmc树结构列表
        List<UpgradeInfoDTO> upgradeInfoDTOList = gmcService.getDeploy(true, null);
        if (CollectionUtils.isEmpty(upgradeInfoDTOList)) {
            return new ArrayList<>();
        }
        Map<String, List<UpgradeInfoDTO>> upgradeInfoGroup = upgradeInfoDTOList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));

        // 查询当前用户可用的应用列表，无论是否授权，平台的数据都可以查看
        List<String> appIdList = queryCurUserAppList();
        appIdList.add("Athena");
        // 校验租户是否授权该应用
        List<UpgradeInfoDTO> upgradeInfoList = Lists.newArrayList();
        for (Map.Entry<String, List<UpgradeInfoDTO>> entry : upgradeInfoGroup.entrySet()) {
            if (cacService.verifyAppAuthorized(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), entry.getKey())
                    && appIdList.contains(entry.getKey())) {
                upgradeInfoList.addAll(entry.getValue());
            }
        }
        if (CollectionUtils.isEmpty(upgradeInfoList)) {
            return new ArrayList<>();
        }
        upgradeInfoList = upgradeInfoList.stream().sorted(Comparator.comparing(UpgradeInfoDTO::getUpdateTime).reversed()).collect(Collectors.toList());

        // 非重要
        AtomicLong isRed = new AtomicLong(0);
        UpgradeInfoDTO upgradeInfoDTOFirst = upgradeInfoList.get(0);
        if (UpgradeTypeEnum.UPGRADE_INSTRUCTIONS.getValue().equals(upgradeInfoDTOFirst.getInfoLevel())) {
            String key = "upgrade-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                    + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

            Object currentTime = cacheService.get(key);
            if (currentTime == null) {
                List<UpgradeBrowseDetail> list = queryBrowseTime(UpgradePriorityEnum.COMMON_UPGRADE.getValue());
                if (CollectionUtils.isNotEmpty(list)) {
                    String browseTime = list.get(0).getBrowseTime();
                    currentTime = StringUtils.isBlank(browseTime) ? null : DateUtil.parseDateTime(browseTime).getTime();
                }
            }
            // 用户上次浏览时间为空 || 版更时间 > 用户上次浏览时间
            if (Objects.isNull(currentTime)
                    || DateUtils.compare(TimeUtils.parseDate(upgradeInfoDTOFirst.getUpdateTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                    new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1);
            }
        } else if (UpgradeTypeEnum.STRONG_REMINDER.getValue().equals(upgradeInfoDTOFirst.getInfoLevel())){
            String key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                    + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

            Object currentTime = cacheService.get(key);
            if (currentTime == null) {
                List<UpgradeBrowseDetail> list = queryBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue());
                if (CollectionUtils.isNotEmpty(list)) {
                    String browseTime = list.get(0).getBrowseTime();
                    currentTime = StringUtils.isBlank(browseTime) ? null : DateUtil.parseDateTime(browseTime).getTime();
                }
            }
            // 重要版更时间 > 用户上次浏览重要版更时间
            // 用户上次浏览时间为空 || 版更时间 > 用户上次浏览时间
            if (Objects.isNull(currentTime)
                    || DateUtils.compare(TimeUtils.parseDate(upgradeInfoDTOFirst.getUpdateTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                    new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1);
            }
        } else {
            String key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                    + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

            Object currentTime = cacheService.get(key);
            if (currentTime == null) {
                List<UpgradeBrowseDetail> list = queryBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue());
                if (CollectionUtils.isNotEmpty(list)) {
                    String browseTime = list.get(0).getBrowseTime();
                    currentTime = StringUtils.isBlank(browseTime) ? null : DateUtil.parseDateTime(browseTime).getTime();
                }
            }
            // 重要版更时间 > 用户上次浏览重要版更时间
            // 用户上次浏览时间为空 || 版更时间 > 用户上次浏览时间
            if (Objects.isNull(currentTime)
                    || DateUtils.compare(TimeUtils.parseDate(upgradeInfoDTOFirst.getUpdateTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                    new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1);
            }
        }

        // 计算升级说明/重要版更的未读数量
        Map<Integer, List<UpgradeInfoDTO>> upgradeInfoMap = upgradeInfoList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getInfoLevel));
        AtomicLong imptUpgradeCount = new AtomicLong(0);
        AtomicLong strongUpgradeCount = new AtomicLong(0);
        for (Map.Entry<Integer, List<UpgradeInfoDTO>> entry : upgradeInfoMap.entrySet()) {
            entry.getValue().stream().forEach(upgradeInfoDTO -> {
                // 重要算数量
                if (UpgradeTypeEnum.IMPT_GRADE.getValue().equals(entry.getKey())) {
                    String key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                            + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                    Object currentTime = cacheService.get(key);
                    if (currentTime == null) {
                        List<UpgradeBrowseDetail> list = queryBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue());
                        if (CollectionUtils.isNotEmpty(list)) {
                            String browseTime = list.get(0).getBrowseTime();
                            currentTime = StringUtils.isBlank(browseTime) ? null : DateUtil.parseDateTime(browseTime).getTime();
                        }
                    }

                    // 重要版更时间 > 用户上次浏览重要版更时间
                    // 用户上次浏览时间为空 || 版更时间 > 用户上次浏览时间
                    if (Objects.isNull(currentTime)
                            || DateUtils.compare(TimeUtils.parseDate(upgradeInfoDTO.getUpdateTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                            new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                        imptUpgradeCount.getAndIncrement();
                    }
                } else if (UpgradeTypeEnum.STRONG_REMINDER.getValue().equals(entry.getKey())) {
                    String key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                            + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                    Object currentTime = cacheService.get(key);
                    if (currentTime == null) {
                        List<UpgradeBrowseDetail> list = queryBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue());
                        if (CollectionUtils.isNotEmpty(list)) {
                            String browseTime = list.get(0).getBrowseTime();
                            currentTime = StringUtils.isBlank(browseTime) ? null : DateUtil.parseDateTime(browseTime).getTime();
                        }
                    }

                    // 重要版更时间 > 用户上次浏览重要版更时间
                    // 用户上次浏览时间为空 || 版更时间 > 用户上次浏览时间
                    if (Objects.isNull(currentTime)
                            || DateUtils.compare(TimeUtils.parseDate(upgradeInfoDTO.getUpdateTime(), DateUtils.DATE_TIME_NORMAL_FORMATTER),
                            new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                        strongUpgradeCount.getAndIncrement();
                    }
                }
            });
        }
        List<UpgradeInfoResp> strongUpgradeResultList = Lists.newArrayList();
        // 获取强提醒的版更通知列表
        if (strongUpgradeCount.get() > 0) {
            // 查询当前用户已读版更列表
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            List<UpgradeReadDetail> readDetailList = upgradeReadDetailService.list(new QueryWrapper<UpgradeReadDetail>()
                    .eq("tenant_id", authoredUser.getTenantId()).eq("user_id", authoredUser.getUserId()));
            List<String> readInfoIdList = readDetailList.stream().map(UpgradeReadDetail::getUpgradeInfoId).collect(Collectors.toList());
            List<UpgradeInfoDTO> strongUpgradeInfoList = upgradeInfoList.stream().filter(upgradeInfoDTO -> {
                String title = null;
                if (CollectionUtils.isNotEmpty(upgradeInfoDTO.getDetails())) {
                    Optional<UpgradeInfoDTO.DetailDTO> first = upgradeInfoDTO.getDetails().stream().filter(detail -> "概要总览".equals(detail.getTitle())).findFirst();
                    if (first.isPresent()) {
                        if (CollectionUtils.isNotEmpty(first.get().getContent())) {
                            title = first.get().getContent().get(0).getText();
                        }
                    }
                }
                upgradeInfoDTO.setTitle(title);
                return StringUtils.isNotBlank(title) && UpgradeTypeEnum.STRONG_REMINDER.getValue() == upgradeInfoDTO.getInfoLevel() && !readInfoIdList.contains(upgradeInfoDTO.getSid());
            }).collect(Collectors.toList());
            // 数量以实际已读为准
            strongUpgradeCount.set(strongUpgradeInfoList.size());
            Map<String, List<UpgradeInfoDTO>> strongUpgradeInfoGroup = strongUpgradeInfoList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));
            for (Map.Entry<String, List<UpgradeInfoDTO>> entry : strongUpgradeInfoGroup.entrySet()) {
                // “Athena”展示成“平台版本”
                String appName = "Athena".equals(entry.getValue().get(0).getName()) ? "平台版本" : entry.getValue().get(0).getName();
                UpgradeInfoResp upgradeInfoResp = UpgradeInfoResp.builder().code(entry.getKey()).name(translateService.translateTextCache(appName, StringUtils.EMPTY)).build();
                List<UpgradeInfoVO> upgradeInfoVOList = entry.getValue().stream().map(upgradeInfoDTO -> {
                    UpgradeInfoVO upgradeInfoVO = UpgradeInfoVO.builder()
                            .upgradeInfoId(upgradeInfoDTO.getSid()).infoLevel(upgradeInfoDTO.getInfoLevel()).updateTime(upgradeInfoDTO.getUpdateTime()).title(upgradeInfoDTO.getTitle()).build();
                    // 标识版更提醒为已读
                    if (readInfoIdList.contains(upgradeInfoDTO.getSid())) {
                        upgradeInfoVO.setRead(true);
                    }
                    return upgradeInfoVO;
                }).collect(Collectors.toList());
                upgradeInfoResp.setUpgradeInfoList(upgradeInfoVOList);
                strongUpgradeResultList.add(upgradeInfoResp);
            }
        }

        return Lists.newArrayList(
                UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.UPGRADE_INSTRUCTIONS.getValue()).unreadCount(isRed.get()).build(),
                UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.IMPT_GRADE.getValue()).unreadCount(imptUpgradeCount.get()).build(),
                UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.STRONG_REMINDER.getValue()).unreadCount(strongUpgradeCount.get()).list(strongUpgradeResultList).build());
    }


    /**
     * 查询当前用户当前租户的某个版更提醒浏览时间
     *
     * @param browseType 类型：1升级提醒；2重要版更
     * @return 返回
     */
    private List<UpgradeBrowseDetail> queryBrowseTime(Integer browseType) {
        LambdaQueryWrapper<UpgradeBrowseDetail> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UpgradeBrowseDetail::getUserId, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        queryWrapper.eq(UpgradeBrowseDetail::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(UpgradeBrowseDetail::getBrowseType, browseType);
        return upgradeBrowseDetailService.list(queryWrapper);
    }

    /**
     * 查询当前用户可用的应用列表
     *
     * @return 返回
     */
    private List<String> queryCurUserAppList() {
        JSONArray jsonArray = cacService.queryCurrentUserAppList();
        List<String> appIdList = jsonArray.stream().filter(x -> {
            LinkedHashMap map = (LinkedHashMap) x;
            String expiredTime = String.valueOf(map.get("expiredTime"));
            return LocalDateTime.now().compareTo(LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_NORMAL_FORMATTER))) < 0;
        }).map(x -> String.valueOf(((LinkedHashMap) x).get("id"))).collect(Collectors.toList());
        return appIdList;
    }

    /**
     * 重要版更提醒关闭
     */
    @Override
    public void closeImptReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());

        // 刷新当前用户当前租户的重要版更浏览时间
        String key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

        cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);

        // 更新当前用户当前租户的重要版更浏览时间
        updateBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue(), currentTime);
    }

    /**
     * 普通版更提醒关闭
     */
    @Override
    public void closeUpgradeReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());

        // 刷新当前用户当前租户的重要版更浏览时间
        String key = "upgrade-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

        cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);

        // 更新当前用户当前租户的版更浏览时间
        updateBrowseTime(UpgradePriorityEnum.COMMON_UPGRADE.getValue(), currentTime);
    }

    /**
     * 更新当前用户当前租户的某个版更提醒浏览时间
     *
     * @param browseType 类型：1升级提醒；2重要版更
     * @param currentTime 当前时间
     */
    private void updateBrowseTime(Integer browseType, String currentTime) {
        UpgradeBrowseDetail upgradeBrowseDetail = new UpgradeBrowseDetail();
        upgradeBrowseDetail.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        upgradeBrowseDetail.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        upgradeBrowseDetail.setBrowseType(browseType);
        upgradeBrowseDetail.setBrowseTime(TimeUtils.format(new Date(Long.parseLong(currentTime)), DateUtils.DATE_TIME_NORMAL_FORMATTER));

        List<UpgradeBrowseDetail> list = queryBrowseTime(browseType);
        if (CollectionUtils.isNotEmpty(list)) {
            upgradeBrowseDetail.setId(list.get(0).getId());
            upgradeBrowseDetailService.updateById(upgradeBrowseDetail);
        } else {
            upgradeBrowseDetail.setId(SnowflakeIdWorker.getInstance().newId());
            upgradeBrowseDetailService.save(upgradeBrowseDetail);
        }
    }

    /**
     * 查询版更系统详情
     *
     * @param upgradeInfoId 版更信息Id
     * @return 版更详情
     */
    @Override
    @Transactional
    public UpgradeInfoDetailResp queryUpgradeDetail(String upgradeInfoId) {
        UpgradeInfoDetailResp upgradeInfoDetailResp = new UpgradeInfoDetailResp();
        // 查询版更详情
        List<UpgradeInfoDTO> upgradeInfoDTOList = gmcService.getDeploy(true, upgradeInfoId);
        if (CollectionUtils.isEmpty(upgradeInfoDTOList)) {
            return upgradeInfoDetailResp;
        }

        // 标题、版本号、版更时间
        UpgradeInfoDTO upgradeInfoDTO = upgradeInfoDTOList.get(0);
        upgradeInfoDetailResp.setDeployNote(upgradeInfoDTO.getDeployNote());
        upgradeInfoDetailResp.setUpdateTime(upgradeInfoDTO.getUpdateTime());
        upgradeInfoDetailResp.setTitle(translateService.translateTextCache(upgradeInfoDTO.getTitle(), StringUtils.EMPTY));

        if (CollectionUtils.isEmpty(upgradeInfoDTO.getDetails())) {
            return upgradeInfoDetailResp;
        }
        // 如果某条版更说明没有概要说明（即文字部分），则这条数据不展示
        List<UpgradeInfoDTO.DetailDTO> details = upgradeInfoDTO.getDetails();
        details.forEach(detailDTO -> {
            List<UpgradeInfoDTO.ContentDTO> noTextContentList = detailDTO.getContent().stream().filter(contentDTO -> StringUtils.isNotBlank(contentDTO.getText())).collect(Collectors.toList());
            detailDTO.setContent(noTextContentList);
        });
        // 如果某大类(概要总览、新增内容、优化内容)没有详情，则该大类不展示
        List<UpgradeInfoDTO.DetailDTO> detailList = details.stream().filter(detailDTO -> CollectionUtils.isNotEmpty(detailDTO.getContent())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailList)) {
            return upgradeInfoDetailResp;
        }
        // 概要总览只展示第一条
        detailList.stream().filter(x -> "概要总览".equals(x.getTitle())).forEach(x -> {
            UpgradeInfoDTO.ContentDTO contentDTO = x.getContent().get(0);
            x.setContent(Collections.singletonList(contentDTO));
        });

        // 调用dmc,查询版更详情中的文件信息
        List<String> fileIdList = filterFileIdList(detailList);
        Map<String, Object> fileIdMap = queryFileInfoList(fileIdList);

        // 构建返回对象
        List<UpgradeInfoDetailResp.UpgradeInfoDetailVO> detailVOList = detailList.stream().map(detailDTO -> {
            // 版跟大类
            UpgradeInfoDetailResp.UpgradeInfoDetailVO detailVO = new UpgradeInfoDetailResp.UpgradeInfoDetailVO();
            detailVO.setTitle(translateService.translateTextCache(detailDTO.getTitle(), StringUtils.EMPTY));
            // 版更内容说明
            List<UpgradeInfoDetailResp.ContentVO> contentVOList = detailDTO.getContent().stream().map(contentDTO -> {
                UpgradeInfoDetailResp.ContentVO contentVO = new UpgradeInfoDetailResp.ContentVO();
                contentVO.setText(translateService.translateTextCache(contentDTO.getText(), upgradeInfoId));
                // 图片列表
                List<UpgradeInfoDetailResp.DetailFile> pictureList = buildDetailFileInfo(contentDTO.getImgUrl(), fileIdMap);
                contentVO.setPicture(pictureList);
                // 视频列表
                List<UpgradeInfoDetailResp.DetailFile> videoList = buildDetailFileInfo(contentDTO.getVideoUrl(), fileIdMap);
                contentVO.setVideo(videoList);
                // 附件列表,只展示pdf文件
                List<UpgradeInfoDetailResp.DetailFile> attList = buildDetailFileInfo(contentDTO.getAttachmentUrl(), fileIdMap);
                List<UpgradeInfoDetailResp.DetailFile> pdfAttList = attList.stream().filter(x -> "pdf".equals(x.getType())).collect(Collectors.toList());
                contentVO.setAttachment(pdfAttList);
                return contentVO;
            }).collect(Collectors.toList());
            detailVO.setContent(contentVOList);
            return detailVO;
        }).collect(Collectors.toList());
        upgradeInfoDetailResp.setDetails(detailVOList);

        // 如果版更信息为未读，则记录为已读
        readRecord(upgradeInfoId);
        return upgradeInfoDetailResp;
    }

    /**
     * 如果版更信息为未读，则记录为已读
     *
     * @param upgradeInfoId 版更id
     */
    private void readRecord(String upgradeInfoId) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        UpgradeReadDetail upgradeReadDetail = upgradeReadDetailService.getOne(new QueryWrapper<UpgradeReadDetail>()
                .eq("user_id", authoredUser.getUserId())
                .eq("tenant_id", authoredUser.getTenantId())
                .eq("upgrade_info_id", upgradeInfoId));

        if (Objects.isNull(upgradeReadDetail)) {
            upgradeReadDetail = UpgradeReadDetail.builder()
                    .id(SnowflakeIdWorker.getInstance().newId())
                    .userId(authoredUser.getUserId())
                    .tenantId(authoredUser.getTenantId())
                    .upgradeInfoId(upgradeInfoId)
                    .build();
            upgradeReadDetailService.save(upgradeReadDetail);
        }
    }

    /**
     * 构建版更说明中的文件信息
     *
     * @param fileIdStr 文件id字符串
     * @param fileIdMap 文件信息
     * @return 返回
     */
    private List<UpgradeInfoDetailResp.DetailFile> buildDetailFileInfo(String fileIdStr, Map<String, Object> fileIdMap) {
        List<UpgradeInfoDetailResp.DetailFile> pictureList = Lists.newArrayList();
        if (StringUtils.isNotBlank(fileIdStr) && MapUtils.isNotEmpty(fileIdMap)) {
            String[] fileIdArray = fileIdStr.split(",");
            for (String fileId : fileIdArray) {
                UpgradeInfoDetailResp.DetailFile detailFile = new UpgradeInfoDetailResp.DetailFile();
                // 文件id
                detailFile.setFileId(fileId.trim());
                pictureList.add(detailFile);
                if (Objects.isNull(fileIdMap.get(fileId.trim()))) {
                    continue;
                }
                LinkedHashMap file = (LinkedHashMap) fileIdMap.get(fileId.trim());
                // 文件名称
                detailFile.setName(String.valueOf(file.get("fileName")));
                // 文件后缀
                detailFile.setType(String.valueOf(file.get("extension")));
                // 文件链接
                detailFile.setUrl(envProperties.getDmcUri() + DMC_FILE_PREVIEW_PATH + fileId.trim());
            }
        }
        return pictureList;
    }

    /**
     * 调用dmc查询版更详情文件的信息
     * 除登录接口外所有接口都必传登录接口返回的userToken
     *
     * @param fileIdList 文件id列表
     * @return 返回
     */
    private Map<String, Object> queryFileInfoList(List<String> fileIdList) {
        if (CollectionUtils.isEmpty(fileIdList)) {
            return Maps.newHashMap();
        }
        String dmcUserToken = dmcService.loginDmc();
        JSONArray fileInfoArray = dmcService.queryFileInfoList(fileIdList, dmcUserToken);
        Map<String, Object> fileMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(fileInfoArray)) {
            fileMap = fileInfoArray.stream().collect(Collectors.toMap(x -> {
                LinkedHashMap map = (LinkedHashMap) x;
                return String.valueOf(map.get("id"));
            }, y -> y, (a, b) -> a));
        }
        return fileMap;
    }

    /**
     * 获取版更详情各个内容的文件id
     *
     * @param detailList 版更详情
     * @return 返回
     */
    private List<String> filterFileIdList(List<UpgradeInfoDTO.DetailDTO> detailList) {
        List<String> fileIdList = Lists.newArrayList();
        detailList.forEach(detailDTO -> detailDTO.getContent().forEach(contentDTO -> {
            // 图片，最多展示10张
            if (StringUtils.isNotBlank(contentDTO.getImgUrl())) {
                String[] imgIdArray = contentDTO.getImgUrl().split(",").length > Constants.NUMBER_TEN ? Arrays.copyOfRange(contentDTO.getImgUrl().split(","), 0, Constants.NUMBER_TEN) : contentDTO.getImgUrl().split(",");
                fileIdList.addAll(Arrays.asList(imgIdArray));
                contentDTO.setImgUrl(Joiner.on(",").join(imgIdArray));
            }
            // 视频，最多展示5个
            if (StringUtils.isNotBlank(contentDTO.getVideoUrl())) {
                String[] videoIdArray = contentDTO.getVideoUrl().split(",").length > Constants.NUMBER_FIVE ? Arrays.copyOfRange(contentDTO.getVideoUrl().split(","), 0, Constants.NUMBER_FIVE) : contentDTO.getVideoUrl().split(",");
                fileIdList.addAll(Arrays.asList(videoIdArray));
                contentDTO.setVideoUrl(Joiner.on(",").join(videoIdArray));
            }
            // 附件，最多展示10个
            if (StringUtils.isNotBlank(contentDTO.getAttachmentUrl())) {
                String[] attIdArray = contentDTO.getAttachmentUrl().split(",").length > Constants.NUMBER_TEN ? Arrays.copyOfRange(contentDTO.getAttachmentUrl().split(","), 0, Constants.NUMBER_TEN) : contentDTO.getAttachmentUrl().split(",");
                fileIdList.addAll(Arrays.asList(attIdArray));
                contentDTO.setAttachmentUrl(Joiner.on(",").join(attIdArray));
            }
        }));
        return fileIdList.stream().map(String::trim).distinct().collect(Collectors.toList());
    }

    /**
     * 查询版更列表
     *
     * @return 返回
     */
    @Override
    public List<UpgradeInfoResp> queryUpgradeInfoList() {
        // 获取版更信息列表
        List<UpgradeInfoDTO> upgradeInfoDTOList = gmcService.getDeploy(false, null);
        if (CollectionUtils.isEmpty(upgradeInfoDTOList)) {
            return new ArrayList<>();
        }

        // 查询当前用户可用的应用列表，无论是否授权，平台的数据都可以查看
        List<String> appIdList = queryCurUserAppList();
        appIdList.add("Athena");
        // 查询当前用户已读版更列表
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List<UpgradeReadDetail> readDetailList = upgradeReadDetailService.list(new QueryWrapper<UpgradeReadDetail>()
                .eq("tenant_id", authoredUser.getTenantId()).eq("user_id", authoredUser.getUserId()));
        List<String> readInfoIdList = readDetailList.stream().map(UpgradeReadDetail::getUpgradeInfoId).collect(Collectors.toList());

        // 构建返回对象
        Map<String, List<UpgradeInfoDTO>> upgradeInfoGroup = upgradeInfoDTOList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));
        List<UpgradeInfoResp> upgradeInfoList = Lists.newArrayList();
        for (Map.Entry<String, List<UpgradeInfoDTO>> entry : upgradeInfoGroup.entrySet()) {
            // 校验租户是否授权该应用
            if (!cacService.verifyAppAuthorized(authoredUser.getTenantId(), entry.getKey())) {
                continue;
            }
            // 判断当前用户能否看到该应用
            if (!appIdList.contains(entry.getKey())) {
                continue;
            }
            // “Athena”展示成“平台版本”
            String appName = "Athena".equals(entry.getValue().get(0).getName()) ? "平台版本" : entry.getValue().get(0).getName();
            UpgradeInfoResp upgradeInfoResp = UpgradeInfoResp.builder().code(entry.getKey()).name(translateService.translateTextCache(appName, StringUtils.EMPTY)).build();
            List<UpgradeInfoVO> upgradeInfoVOList = entry.getValue().stream().map(upgradeInfoDTO -> {
                UpgradeInfoVO upgradeInfoVO = UpgradeInfoVO.builder()
                        .upgradeInfoId(upgradeInfoDTO.getSid()).infoLevel(upgradeInfoDTO.getInfoLevel()).updateTime(upgradeInfoDTO.getUpdateTime()).build();
                // 标识版更提醒为已读
                if (readInfoIdList.contains(upgradeInfoDTO.getSid())) {
                    upgradeInfoVO.setRead(true);
                }
                return upgradeInfoVO;
            }).collect(Collectors.toList());
            upgradeInfoResp.setUpgradeInfoList(upgradeInfoVOList);
            upgradeInfoList.add(upgradeInfoResp);
        }
        // 排序，并把Athena放在第一位
        upgradeInfoList.sort(Comparator.comparing(UpgradeInfoResp::getName));
        List<UpgradeInfoResp> athenaUpgradeList = upgradeInfoList.stream().filter(x -> "Athena".equals(x.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(athenaUpgradeList)) {
            upgradeInfoList.removeIf(x -> "Athena".equals(x.getCode()));
            upgradeInfoList.add(0, athenaUpgradeList.get(0));
        }
        return upgradeInfoList;
    }

    /**
     * 升级说明强提醒关闭
     */
    @Override
    public void closeUpgradeStrongReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());

        // 刷新当前用户当前租户的重要版更浏览时间
        String key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":"
                + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

        cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);

        // 更新当前用户当前租户的重要版更浏览时间
        updateBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue(), currentTime);
    }
}
