package com.digiwin.athena.semc.service.homepage.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.homepage.SaveUserPortalReq;
import com.digiwin.athena.semc.entity.homepage.UserPortalRecord;
import com.digiwin.athena.semc.mapper.homepage.UserPoatalMapper;
import com.digiwin.athena.semc.service.homepage.IUserPortalService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPortalServiceImpl extends ServiceImpl<UserPoatalMapper, UserPortalRecord> implements IUserPortalService {

    @Autowired
    UserPoatalMapper userPoatalMapper;

    /**
     * 查询用户当前使用的门户类型
     *
     * @return
     */
    @Override
    public UserPortalRecord queryLatestUserPortal() {
        QueryWrapper<UserPortalRecord> condition = new QueryWrapper<>();
        if (StringUtils.isNotBlank(AppAuthContextHolder.getContext().getAuthoredUser().getUserId())) {
            condition.eq("create_user_id", AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        }
        if (StringUtils.isNotBlank(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())) {
            condition.eq("tenant_id", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        }
        return userPoatalMapper.selectOne(condition);
    }

    /**
     * 保存切换的门户类型
     *
     * @param saveUserPortalReq 请求实体
     * @return
     */
    @Override
    public Long saveLatestUserPortal(SaveUserPortalReq saveUserPortalReq) {
        UserPortalRecord userPortalRecord = new UserPortalRecord();
        userPortalRecord.setId(saveUserPortalReq.getId());
        userPortalRecord.setPortalType(saveUserPortalReq.getPortalType());
        userPortalRecord.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        userPortalRecord.setTenantSid(AppAuthContextHolder.getContext().getAuthoredUser().getTenantSid());

        UserPortalRecord portalRecord = queryLatestUserPortal();
        // 首次切换门户，保存门户类型
        if (portalRecord == null) {
            userPoatalMapper.insert(userPortalRecord);
            return userPortalRecord.getId();
        } else {
            userPortalRecord.setId(portalRecord.getId());
            userPoatalMapper.updateById(userPortalRecord);
            return portalRecord.getId();
        }
    }
}