package com.digiwin.athena.semc.service.machine;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.machine.TopicPreset;
import com.digiwin.athena.semc.vo.machine.TopicPresetResp;
import com.fasterxml.jackson.core.JsonProcessingException;

import java.util.List;

/**
 * 绿色智机模组作业
 */
public interface TopicPresetService extends IService<TopicPreset> {


    /**
     * 查询用户绿色智机权限
     * @return
     */
    TopicPresetResp queryUserAuth();


    /**
     * 查询用户绿色智机模组和作业
     * @return
     */
    List<TopicPresetResp> queryAllJob(List<String> caseIdList);


    /**
     * 组装绿色智机的跳转地址
     * @param url
     * @return
     */
     String getTopicPresetUrl(String url);

    /**
     * 绿色智机数据迁移到 移动应用/作业管理
     * @param tenantId
     * @return
     */
     Integer initPresetData(String tenantId) throws JsonProcessingException;

}
