package com.digiwin.athena.semc.service.machine.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.entity.machine.TopicPreset;
import com.digiwin.athena.semc.entity.message.DingtalkTemplateRel;
import com.digiwin.athena.semc.entity.message.MessageBlackWhite;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourcePreset;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.message.DingtalkTemplateRelMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourcePresetMapper;
import com.digiwin.athena.semc.mapper.portal.CompanyFactoryMapper;
import com.digiwin.athena.semc.mapper.portal.TopicPresetMapper;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.service.message.DingtalkTemplateRelService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesDTO;
import com.digiwin.athena.semc.vo.machine.TopicPresetJobResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetMyAppResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetResp;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.core.util.CollectionUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
@Slf4j
public class TopicPresetServiceImpl extends ServiceImpl<TopicPresetMapper, TopicPreset> implements TopicPresetService {

    @Resource
    private TopicPresetMapper topicPresetMapper;

    @Resource
    private CompanyFactoryMapper companyFactoryMapper;

    @Resource
    private IamService iamService;

    @Resource
    private EnvProperties envProperties;

    @Resource
    private CacService cacService;

    @Resource
    private MobileDatasourcePresetMapper mobileDatasourcePresetMapper;

    @Override
    public TopicPresetResp queryUserAuth() {
        TopicPresetResp resp = new TopicPresetResp();
        resp.setIsHavePreset(false);
        //查询数据库中预置的应用和作业
        List<TopicPreset> topicPresetList = topicPresetMapper.selectList(null);
        if (CollectionUtils.isEmpty(topicPresetList)) {
            return resp;
        }
        //查询IAM获取商品信息
        JSONArray userAppArray=cacService.queryCurrentUserAppList();
        if (null ==userAppArray) {
            return resp;
        }
        List<UserApplicationModulesDTO> enabledModules = JSONArray.parseArray(JSONObject.toJSONString(userAppArray), UserApplicationModulesDTO.class);
        if (CollectionUtils.isEmpty(enabledModules)) {
            return resp;
        }
        //取出我的应用数据
        List<TopicPreset> myPreList=topicPresetList.stream().filter(x -> x.getTitle().equals(Constants.MY_TOPIC_PRESET)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(myPreList)) {
            return resp;
        }
        TopicPreset myPre = myPreList.get(0);
        if (null == myPre || StringUtils.isEmpty(myPre.getPresetContent())) {
            return resp;
        }
        List<TopicPresetMyAppResp> myAppRespList = JSONArray.parseArray(myPre.getPresetContent(), TopicPresetMyAppResp.class);
        //取出所有moduleId
        List<String> moduleIdList = myAppRespList.stream().map(TopicPresetMyAppResp::getModuleId).collect(Collectors.toList());
        //判断iam返回的是否有绿色智机的模组权限
        for (UserApplicationModulesDTO modules : enabledModules) {
            String moduleId = modules.getId() + Constants.MY_TOPIC_PRESET_SYMBOL;
            //判断是否是TipBiuBI，是TipBiuBI，跳过
            if (modules.getId().toLowerCase().equals(Constants.TBB_APP_ID)) {
                continue;
            }
            //判断是否过期，过期进行下一个判断
            Date expiredTime = DateUtils.strToDate(modules.getExpiredTime());
            // 精确到毫秒
            long expiredMilli = expiredTime.getTime();
            long nowMilli = new Date().getTime();
            //过期时间小于当前时间,已过期
            if (expiredMilli < nowMilli) {
                continue;
            }
            for(String moduleIdStr:moduleIdList){
                //IAM返回的模组应用和预设的模组有权限相交，则判断为有绿色智机项目权限
                if (moduleIdStr.contains(moduleId)) {
                    resp.setIsHavePreset(true);
                    break;
                }
            }
        }
        return resp;
    }




    @Override
    public  List<TopicPresetResp> queryAllJob(List<String> caseIdList) {
        List<TopicPresetResp> topicPresetRespList = new ArrayList<>();
        //查询数据库中预置的应用和作业
        List<TopicPreset> topicPresetList = topicPresetMapper.selectList(null);
        if (CollectionUtils.isEmpty(topicPresetList)) {
            return topicPresetRespList;
        }
        //从cac获取用户有权限的应用
        JSONArray userAppArray=cacService.queryCurrentUserAppList();
        if (null ==userAppArray) {
            return topicPresetRespList;
        }
        List<UserApplicationModulesDTO> enabledModules = JSONArray.parseArray(JSONObject.toJSONString(userAppArray), UserApplicationModulesDTO.class);
        if (CollectionUtils.isEmpty(enabledModules)) {
            return topicPresetRespList;
        }
        //取出预设数据
        Map<String, TopicPreset> topicPresetMap = topicPresetList.stream().collect(Collectors.toMap(TopicPreset::getTopicPresetId, Function.identity(), (a, b) -> a));
        //取出我的应用数据
        List<TopicPreset> myPreList=topicPresetList.stream().filter(x -> x.getTitle().equals(Constants.MY_TOPIC_PRESET)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(myPreList)) {
            return topicPresetRespList;
        }
        TopicPreset myPre = myPreList.get(0);
        if (null == myPre || StringUtils.isEmpty(myPre.getPresetContent())) {
            return topicPresetRespList;
        }
        //我的应用中作业集合
        List<TopicPresetMyAppResp> myAppRespList = JSONArray.parseArray(myPre.getPresetContent(), TopicPresetMyAppResp.class);
        //取出所有moduleId
        List<String> moduleIdList = myAppRespList.stream().map(TopicPresetMyAppResp::getModuleId).collect(Collectors.toList());
        List<String> targetList = new ArrayList<>();
        //判断iam返回的是否有绿色智机的模组权限
        for (UserApplicationModulesDTO modules : enabledModules) {
            String moduleId = modules.getId() + Constants.MY_TOPIC_PRESET_SYMBOL;
            //判断是否是TipBiuBI，是TipBiuBI，跳过
            if (modules.getId().toLowerCase().equals(Constants.TBB_APP_ID)) {
                continue;
            }
            String target = Constants.IAM_FUNCTIONAL_STR + modules.getId();
            //判断是否过期，过期进行下一个判断
            Date expiredTime = DateUtils.strToDate(modules.getExpiredTime());
            // 精确到毫秒
            long expiredMilli = expiredTime.getTime();
            long nowMilli = new Date().getTime();
            //过期时间小于当前时间,已过期
            if (expiredMilli < nowMilli) {
                continue;
            }
            for(String moduleIdStr:moduleIdList){
                //IAM返回的模组应用和预设的模组有权限相交，则判断为有绿色智机项目权限,组装请求iam功能权限入参
                if (moduleIdStr.startsWith(moduleId) && !targetList.contains(target)) {
                    targetList.add(target);
                }
            }

        }
        //请求IAM接口获取功能权限
        List<String> sidList = getUserJobSidList(targetList);
        //没有作业权限
        if (CollectionUtils.isEmpty(sidList)) {
            return topicPresetRespList;
        }
        List<String> interSidList = new ArrayList<>();
        interSidList.addAll(sidList);
        //按查询作业权限过滤
        if (CollectionUtils.isNotEmpty(caseIdList)) {
            interSidList=Utils.intersect(sidList,caseIdList);
        }
        //根据有权限的作业过滤，得到有权限的作业
        List<String> finalInterSidList = interSidList;
        myAppRespList = myAppRespList.stream().filter(x -> finalInterSidList.contains(x.getCaseId())).collect(Collectors.toList());
        //组装url
        packageTopicPreset(myAppRespList, topicPresetRespList, topicPresetMap);
        return topicPresetRespList;
    }

    /**
     * 组装作业信息
     * @param myAppRespList 权限内的模组作业信息
     * @param topicPresetRespList 返回的模组作业数据
     * @param topicPresetMap 数据库预设数据
     */
   public void packageTopicPreset(List<TopicPresetMyAppResp> myAppRespList,List<TopicPresetResp> topicPresetRespList,Map<String, TopicPreset> topicPresetMap) {
       Map<String, TopicPresetResp> respMap = new HashMap<>();
       //语言
       String locale = LocaleContextHolder.getLocale().toString();
       for (TopicPresetMyAppResp myAppResp : myAppRespList) {
           TopicPreset topicPreset = topicPresetMap.get(myAppResp.getTopicpresetId());
           TopicPresetJobResp jobResp = new TopicPresetJobResp();
           jobResp.setCaseId(myAppResp.getCaseId());
           jobResp.setTopicPresetId(myAppResp.getTopicpresetId());
           //作业名称
           String topicPresetName = getTopicPresetName(myAppResp.getTopicpresetName(), locale, topicPreset);
           jobResp.setTopicPresetName(topicPresetName);
           //作业icon地址
           if(StringUtils.isNotEmpty(topicPreset.getCustomPicId())){
               String topicPresetIcon = envProperties.getAppIconUrl() + topicPreset.getCustomPicId().trim();
               jobResp.setTopicPresetIcon(topicPresetIcon);
           }
           //作业跳转url
           String topicPresetUrl = getTopicPresetUrl(locale, topicPreset,jobResp);
           jobResp.setTopicPresetUrl(topicPresetUrl);
           TopicPresetResp presetResp = respMap.get(myAppResp.getModuleId());
           if (null == presetResp) {
               presetResp = new TopicPresetResp();
               //模组名称
               String moduleName = getModuleName(myAppResp.getModuleName(), locale, myAppResp);
               presetResp.setModuleName(moduleName);
               presetResp.setModuleId(myAppResp.getModuleId());
               List<TopicPresetJobResp> topicpPreList = new ArrayList<>();
               topicpPreList.add(jobResp);
               presetResp.setTopicpList(topicpPreList);
           } else {
               List<TopicPresetJobResp> topicpPreList = presetResp.getTopicpList();
               topicpPreList.add(jobResp);
               presetResp.setTopicpList(topicpPreList);
           }
           respMap.put(myAppResp.getModuleId(), presetResp);
       }
       //遍历组装返回数据
       Set<Map.Entry<String, TopicPresetResp>> entries = respMap.entrySet();
       for (Map.Entry<String, TopicPresetResp> entry : entries) {
           TopicPresetResp presetResp = new TopicPresetResp();
           String key = entry.getKey();
           TopicPresetResp value = entry.getValue();
           presetResp.setModuleId(key);
           presetResp.setModuleName(value.getModuleName());
           presetResp.setTopicpList(value.getTopicpList());
           topicPresetRespList.add(presetResp);
       }

   }

    /**
     * 获取模组名称
     * @param moduleName 默认模组名称
     * @param locale 语言
     * @param myAppResp 模组作业信息
     * @return
     */
    public String getModuleName(String moduleName,String locale,TopicPresetMyAppResp myAppResp) {
        if (null == myAppResp.getMutiPageTitle()) {
            return moduleName;
        }
        if (locale.equals(Constants.ZH_CN_LOCALE)) {
            locale = Constants.ZH_CH_LOCALE;
        }
        String key = "mutiPageTitle_" + locale;
        if (StringUtils.isEmpty(myAppResp.getMutiPageTitle().get(key))) {
            return moduleName;
        }
        //根据语言获取模组名称
        moduleName = myAppResp.getMutiPageTitle().get(key);
        return moduleName;
    }

    /**
     * 获取作业跳转url
     * @param topicPreset 作业信息
     * @return
     */
    public String getTopicPresetUrl(String locale,TopicPreset topicPreset,TopicPresetJobResp jobResp) {
        String jobUrl = "";
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            ObjectMapper mapper = new ObjectMapper();
            // 将JSON字符串转换为Map<String, Object>
            Map<String, String> presetContentMap = mapper.readValue(topicPreset.getPresetContent(), Map.class);
            String url = presetContentMap.get("url");
            jobUrl = envProperties.getAppCustomizeUrl() + Utils.getInfo(url, userToken, locale, userId, tenantId);
            //查询公司别和厂别
            CompanyFactory companyFactory = getUserCompany();
            jobResp.setIsSetCompany(false);
            if (null == companyFactory) {
                return jobUrl;
            }
            jobResp.setIsSetCompany(true);
            jobUrl = jobUrl + packageCompUrl(companyFactory);
        } catch (JsonProcessingException e) {
            log.error("getTopicPresetUrl PresetContent:{},errorMessage:{}", topicPreset.getPresetContent(), e.getMessage());
            return jobUrl;
        }
        return jobUrl;
    }

    /**
     * &enterpriseFactoryInfo=[{"enterpriseId":"DSC","factoryId":"DEMOSITE"}]
     * @param companyFactory
     * @return
     */
    public String packageCompUrl(CompanyFactory companyFactory) {
        String compUrl = Constants.ENTER_PRISE_FACTORY_INFO;
        JSONObject obj=new JSONObject(true);
        obj.put("thirdPartySystemId",envProperties.getThirdPartySystemId());
        obj.put("enterpriseId",companyFactory.getCompany());
        obj.put("factoryId",companyFactory.getFactory());
        JSONArray array=new JSONArray();
        array.add(obj);
        try {
            compUrl =compUrl+URLEncoder.encode(JSONObject.toJSONString(array), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("packageCompUrl URLEncoder报错， e：{}", e);
        }
        return compUrl;
    }

    /**
     *获取登录用户的公司别厂别
     * @return
     */
   public CompanyFactory getUserCompany(){
       String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
       LambdaQueryWrapper<CompanyFactory> wrapper = new LambdaQueryWrapper<>();
       wrapper.eq(CompanyFactory::getCreateUserId,userId);
       return  companyFactoryMapper.selectOne(wrapper);
   }


    @Override
    public String getTopicPresetUrl(String url) {
        String locale = LocaleContextHolder.getLocale().toString();
        url = Utils.getInfo(url, Utils.getUserToken(), locale, Utils.getUserId(), Utils.getTenantId());
        //查询公司别和厂别
        CompanyFactory companyFactory = getUserCompany();
        if (null == companyFactory) {
            return url;
        }
        url = url + packageCompUrl(companyFactory);
        return url;
    }


    /**
     * 获取作业名称
     * @param topicPresetName 默认作业名称
     * @param locale 语言
     * @param topicPreset 作业信息
     * @return
     */
   public String getTopicPresetName(String topicPresetName,String locale,TopicPreset topicPreset) {
       if (null == topicPreset) {
           return topicPresetName;
       }
       if (StringUtils.isEmpty(topicPreset.getPresetContent())) {
           return topicPresetName;
       }
       try {
           ObjectMapper mapper = new ObjectMapper();
           // 将JSON字符串转换为Map<String, Object>
           Map<String, String> presetContentMap = mapper.readValue(topicPreset.getPresetContent(), Map.class);
           String key = "title_" + locale;
           if (StringUtils.isEmpty(presetContentMap.get(key))) {
               return topicPresetName;
           }
           //根据语言获取作业名称
           topicPresetName = presetContentMap.get(key);
       } catch (JsonProcessingException e) {
           log.error("getTopicPresetName PresetContent:{},errorMessage:{}", topicPreset.getPresetContent(), e.getMessage());
           return topicPresetName;
       }
       return topicPresetName;
   }

    /**
     * 请求IAM接口获取功能权限
     * @param targetList
     * @return 模组应用下作业权限的sid 集合
     */
    public List<String> getUserJobSidList(List<String> targetList) {
        List<String> sidList = new ArrayList<>();
        for (String target : targetList) {
            List<PermissionUserFunctionalDTO> userFunctionalDTOS = iamService.queryUserFunctional(target, AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isNotEmpty(userFunctionalDTOS)) {
                List<String> sIdList = userFunctionalDTOS.stream().map(PermissionUserFunctionalDTO::getSid).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sIdList)) {
                    sidList.addAll(sIdList);
                }
            }
        }
        return sidList;
    }

    @Override
    @Transactional
    public Integer initPresetData(String tenantId) throws JsonProcessingException {
        //查询数据库中预置的应用和作业
        List<TopicPreset> topicPresetList = topicPresetMapper.selectList(null);
        //取出预设数据
        Map<String, TopicPreset> topicPresetMap = topicPresetList.stream().collect(Collectors.toMap(TopicPreset::getTopicPresetId, Function.identity(), (a, b) -> a));
        //取出我的应用数据
        List<TopicPreset> myPreList=topicPresetList.stream().filter(x -> x.getTitle().equals(Constants.MY_TOPIC_PRESET)).collect(Collectors.toList());
        TopicPreset myPre = myPreList.get(0);
        //我的应用中作业集合
        List<TopicPresetMyAppResp> myAppRespList = JSONArray.parseArray(myPre.getPresetContent(), TopicPresetMyAppResp.class);
         for(TopicPresetMyAppResp myAppResp:myAppRespList){
             MobileDatasourcePreset preset=new MobileDatasourcePreset();
             preset.setModuleName(myAppResp.getModuleName());
             preset.setJobName(myAppResp.getTopicpresetName());
             preset.setTenantId(tenantId);
             String[] iamId=myAppResp.getModuleId().split(Constants.MY_TOPIC_PRESET_SYMBOL);
             preset.setIamApplicationId(iamId[0]);
             preset.setIamModuleId(iamId[1]);
             preset.setSpecialSign(1);
             TopicPreset topicPreset = topicPresetMap.get(myAppResp.getTopicpresetId());
             if(null !=topicPreset){
                 // 将JSON字符串转换为Map<String, Object>
                 ObjectMapper mapper = new ObjectMapper();
                 Map<String, String> presetContentMap = mapper.readValue(topicPreset.getPresetContent(), Map.class);
                 if(null !=presetContentMap){
                     String url = presetContentMap.get("url");
                     String applicationConfig=envProperties.getAppCustomizeUrl()+url;
                     preset.setApplicationConfig(applicationConfig);
                 }
             }
             mobileDatasourcePresetMapper.insert(preset);
         }
        return null;
    }

}
