package com.digiwin.athena.semc.service.menu;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.menu.DeleteMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.QueryMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.UpdateMenuTemplateReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;

import java.util.List;

/**
 * 自定义菜单模板表(TCustomizedMenuTemplate)表服务接口
 *
 * @author sungqz
 * @since 2023-11-08
 */
public interface CustomizedMenuTemplateService extends IService<CustomizedMenuTemplate> {

    /**
     * 自定义菜单列表配置查询菜单模板列表
     *
     * @return 返回对象
     */
    PageInfoResp<CustomizedMenuTemplate> queryMenuTemplateList(QueryMenuTemplateReq queryMenuTemplateReq);

    /**
     * 查询菜单
     *
     * @param queryMenuTemplateReq
     * @return
     */
    List<CustomizedMenuTemplate> queryEnableMenuTemplateList();

    /**
     * 更新菜单模板状态
     *
     * @param updateMenuTemplateReq 入参
     * @return 返回对象
     */
    Boolean updateStatus(UpdateMenuTemplateReq updateMenuTemplateReq);

    /**
     * 通过模板id主键删除数据
     *
     * @param deleteMenuTemplateReq 入参
     * @return 是否成功
     */
    Boolean deleteTemplateById(DeleteMenuTemplateReq deleteMenuTemplateReq);

    /**
     * 门户布局查询菜单模板列表
     *
     * @param queryMenuTemplateReq 入参
     * @param portalMenuTempId 门户关联的菜单模板id
     * @return 返回
     */
    ResultPageBean queryPortalTempList(QueryMenuTemplateReq queryMenuTemplateReq, Long portalMenuTempId);

    /**
     * 检验模板名称是否存在
     *
     * @param templateId 模板id
     * @param templateName 模板名称
     * @return 返回对象
     */
    Boolean validExist(Long templateId, String templateName);

    /**
     * 通过模板id查询模板
     *
     * @param templateId 模板id
     * @return 返回对象
     */
     CustomizedMenuTemplate queryTemplateById(Long templateId);
     /**
     * 通过设计时模板id查询模板
     *
     * @param menuDesignerId 设计时模板id
     * @return 模板
     */
     CustomizedMenuTemplate queryTemplateByDesignerId(Long menuDesignerId);

    /**
     * 通过模板ids查询模板
     *
     * @param templateIds 模板ids
     * @return 返回对象
     */
    List<CustomizedMenuTemplate> queryTemplateByIds(List<Long> templateIds);

    /**
     * 更新租户下其他菜单模板为未发布
     *
     * @param updateMenuTemplateReq 入参
     * @param tenantId 租户ID
     * @return 返回对象
     */
    Boolean unusableOtherTemplate(UpdateMenuTemplateReq updateMenuTemplateReq, String tenantId);
}