package com.digiwin.athena.semc.service.menu;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.menu.SaveMenuReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;

import java.util.List;

/**
 * 自定义菜单作业表(TCustomizedMenuWork)表服务接口
 *
 * @author sungqz
 * @since 2023-11-10
 */
public interface CustomizedMenuWorkService extends IService<CustomizedMenuWork> {

    /**
     * 查询当前模板的菜单树
     *
     * @param templateId 模板id
     * @return 返回对象
     */
    List<CustomizedMenuWorkResp> queryManageMenu(Long templateId);

    /**
     * 保存菜单
     *
     * @param saveMenuReq 入参
     * @param menuList 菜单列表
     * @return 返回对象
     */
    Boolean saveMenu(SaveMenuReq saveMenuReq, List<CustomizedMenuWork> menuList);

    /**
     * 查询前台用户展示的菜单树
     *
     * @param templateId 模板id
     * @param systemMenuFlag 是否展示系统菜单 0:否 1:是
     *
     * @return 返回对象
     */
    JSONObject queryDisplayMenu(Long templateId, Integer systemMenuFlag);

    /**
     * 查询应用作业池列表
     *
     * @return 返回对象
     */
    List<AppJobDTO> queryAppJobList();

    /**
     * 初始化自定义菜单数据：为租户发布来源为 TENANT 的菜单模板，补齐缺失的“待办”预设组件。
     *
     * 实现要点（按需求步骤）：
     * 1. 从 t_customized_menu_template 获取涉及的租户ID集合 tenantIds（仅处理 publish_source=TENANT 的模板）。
     * 2. 基于 tenantIds 查询 t_label_system_pre 中 data_type=0(待办) 的记录，构建 Map<tenantId, preId>。
     * 3. 查询 t_customized_menu 表所有已存在的主键ID，构成 existIds 集合（用于生成全局不重复的 currentId）。
     * 4. 分批（每批500）处理模板ID，批量查询 t_customized_menu 的数据。
     * 5. 按模板ID分组，判断该模板下是否已存在“待办”组件；存在则跳过。
     * 6. 不存在则：
     *    - 从1开始递增寻找未占用且不在 existIds 的 currentId；
     *    - 若 currentId 小于该模板下菜单最小ID，直接以 currentId 新增待办组件；
     *    - 若 currentId 大于该模板下菜单最小ID，则同样新增，并将原来的该模板菜单列表删除后按原数据重新插入（以满足“移除并重新插入”的要求）。
     *
     * 返回：true 表示执行成功。
     */
    Boolean initData();
}