package com.digiwin.athena.semc.service.menu;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.menu.manage.SaveMenuAuthReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;

import java.util.List;

/**
 * 管理后台菜单权限配置 服务接口
 *
 * @author sungqz
 * @since 2024-08-26
 */
public interface ManageMenuAuthService extends IService<ManageMenuAuth> {

    /**
     * 管理后台-查询权限对象关联的菜单
     *
     * @param authId 权限id
     * @return 返回
     */
    List<ManageMenuAuth> queryAuthRelMenu(String authId);

    /**
     * 管理后台-保存权限对象关联的菜单
     *
     * @param saveMenuAuthReq 请求入参
     */
    void saveAuthRelMenu(SaveMenuAuthReq saveMenuAuthReq);

    /**
     * 前台-查询用户关联的菜单
     *
     * @return 返回
     */
    List<ManageMenuAuth> queryUserMenuList();
}