package com.digiwin.athena.semc.service.menu;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.menu.manage.SaveSpecialTenantIdReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import com.digiwin.athena.semc.vo.menu.UserManageMenulVO;

import java.util.List;

/**
 * 管理后台基础菜单配置表(TManageMenu)表服务接口
 *
 * @author sungqz
 * @since 2024-09-30
 */
public interface ManageMenuService extends IService<ManageMenu> {

    /**
     * 查询基础菜单配置列表数据
     *
     * @return 返回
     */
    List<ManageMenu> queryManageMenuConfigList();

    /**
     * 校验menuKey是否存在
     *
     * @param manageMenu 菜单
     * @return 返回
     */
    List<ManageMenu> existMenuKey(ManageMenu manageMenu);

    /**
     * 新增数据
     *
     * @param manageMenu 实例对象
     * @return 实例对象
     */
    ManageMenu insertManageMenu(ManageMenu manageMenu);

    /**
     * 修改数据
     *
     * @param manageMenu 实例对象
     * @return 实例对象
     */
    ManageMenu updateManageMenu(ManageMenu manageMenu);

    /**
     * 通过菜单标识删除菜单
     *
     * @param menuKeyList    菜单key
     * @param manageMenuList 菜单列表
     */
    void deleteByMenuKeyList(List<String> menuKeyList, List<ManageMenu> manageMenuList);

    /**
     * 查询权限设置页面的菜单列表数据
     *
     * @param environmentFlag 所属环境标识 0:全部 1:云上 2:下地
     * @return 返回
     */
    List<ManageMenu> queryManageMenuList(Integer environmentFlag);

    /**
     * 根据条件查询基础菜单列表
     *
     * @param environmentFlag 所属环境标识 0:全部 1:云上 2:下地
     * @param filterPre 是否要走仅预区可见菜单逻辑
     * @param version 菜单版本标识
     * @return 返回
     */
    List<ManageMenu> queryBaseManageMenu(Integer environmentFlag, boolean filterPre, String version);

    /**
     * 管理后台-查询用户的左侧菜单树
     *
     * @param environmentFlag 所属环境标识 0:全部 1:云上 2:下地
     * @return 查询结果
     */
    List<ManageMenu> queryManageMenuTree(Integer environmentFlag);

    /**
     * 校验是否有权限打开菜单
     *
     * @param environmentFlag 所属环境标识 0:全部 1:云上 2:下地
     * @param manageMenu      菜单
     * @return 返回
     */
    boolean validMenuAuth(Integer environmentFlag, ManageMenu manageMenu);

    /**
     * 设置特殊租户和账号
     *
     * @param saveSpecialTenantIdReq 请求入参
     */
    void saveTenantId(SaveSpecialTenantIdReq saveSpecialTenantIdReq);

    /**
     * 获取当前租户的版本号
     *
     * @return 返回
     */
    String getTenantVersion();

    /**
     * 处理菜单版本号
     * @param manageMenu
     * @return 是否需要将当前菜单版本号置空。true：置空，false：不置空
     */
    Boolean handMenuVersion(ManageMenu manageMenu);

    /**
     * 查询用户管理菜单标识
     * @param req
     * @return
     */
    UserManageMenulVO queryUserMenuFlag(UserManageMenulVO req);
}
