package com.digiwin.athena.semc.service.menu.impl;

import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.service.common.EnvService;
import com.digiwin.athena.semc.service.menu.ManageMenuService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.menu.UserManageMenulVO;

import org.springframework.stereotype.Service;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
@RequiredArgsConstructor
public class AuthServiceImpl implements AuthService {

    private final IamService iamService;

    private final ManageMenuService manageMenuService;

    private final EnvService envService;


    @Override
    public boolean isSuperAdmin() {
        List<RoleDTO> roleDTOList = iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
        boolean flag = roleDTOList.stream().anyMatch(x -> x.getId().equals(Constants.SUPER_ADMIN));
        return flag;
    }

    @Override
    public boolean hasMenuAuth(String menuKey) {
        UserManageMenulVO req = new UserManageMenulVO();
        req.setEnvironmentFlag(0);
        req.setMenuKey(menuKey);
        req.setEnvironmentFlag(envService.isOnline() ? 1 : 2);
        UserManageMenulVO userManageMenulVO = manageMenuService.queryUserMenuFlag(req);
        if (userManageMenulVO!=null && Boolean.TRUE.equals(userManageMenulVO.getIsHaveMenu())) {
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAuth(String menuKey) {
        if (isSuperAdmin()) {
            return true;
        }
        return hasMenuAuth(menuKey);
    }
}
