package com.digiwin.athena.semc.service.message;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.message.SaveBlackWhiteReq;
import com.digiwin.athena.semc.entity.message.MessageBlackWhite;

import java.util.List;

/**
 * 消息接收人黑白名单(TMessageBlackWhite)表服务接口
 *
 * @author sungqz
 * @since 2024-01-10
 */
public interface MessageBlackWhiteService extends IService<MessageBlackWhite> {

    /**
     * 查询用户列表
     *
     * @param type 名单类型 0:黑名单 1:白名单
     * @param key  关键字
     * @param tenantId  租户id
     * @return 查询结果
     */
    List<MessageBlackWhite> queryUserList(Integer type, String key, String tenantId);

    /**
     * 根据主键id删除用户
     *
     * @param id 主键id
     * @return 结果
     */
    void delUser(Long id);

    /**
     * 保存用户
     *
     * @param saveBlackWhiteReq 请求对象
     * @return 结果
     */
    void saveUser(SaveBlackWhiteReq saveBlackWhiteReq);
}
