package com.digiwin.athena.semc.service.message;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.message.MessageChannel;

/**
 * 消息发送渠道表(TMessageChannel)表服务接口
 *
 * @author sungqz
 * @since 2023-11-30
 */
public interface MessageChannelService extends IService<MessageChannel> {

    /**
     * 查询租户的消息发送渠道
     *
     * @param userId 用户id
     * @return 查询结果
     */
    MessageChannel queryChannel(String userId,String tenantId);


    /**
     * 查询租户的消息发送渠道
     *
     * @param userId 用户id
     * @return 查询结果
     */
    String queryChannelFlag(String userId, String tenantId);

    /**
     * 保存租户的消息发送渠道
     *
     * @param channelStr 渠道
     * @return 返回对象
     */
    Long saveChannel(String channelStr);
}
