package com.digiwin.athena.semc.service.message;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.message.*;
import com.digiwin.athena.semc.entity.message.MessageChannelTemplate;

import java.util.List;

/**
 * 消息模板配置表服务接口
 *
 * @author sungqz
 * @since 2023-1-8
 */
public interface MessageChannelTemplateService extends IService<MessageChannelTemplate> {

    /**
     * 查询各个渠道模板配置列表
     *
     * @param queryTemplateListReq 请求对象
     * @return 返回对象
     */
    List<QueryTemplateListResp> queryTemplateList(QueryTemplateListReq queryTemplateListReq);

    /**
     * 修改模板状态
     *
     * @param saveTemplateReq 请求对象
     * @return 返回对象
     */
    Long updateStatus(SaveTemplateReq saveTemplateReq);

    /**
     * 更新模板
     *
     * @param saveTemplateReq 请求对象
     * @return 返回对象
     */
    Long updateTemplate(SaveTemplateReq saveTemplateReq);

    /**
     * 查看模板接收人
     *
     * @param templateRelReq 请求对象
     * @return 返回对象
     */
    QueryTemplateRelResp queryRelPerson(TemplateRelReq templateRelReq);

    /**
     * 添加模板接收人
     *
     * @param templateRelReq 请求对象
     * @return 返回对象
     */
    void addRelPerson(TemplateRelReq templateRelReq);

    /**
     * 删除模板收件人
     *
     * @param templateRelReq 请求对象
     * @return 返回结果
     */
    void delRelPerson(TemplateRelReq templateRelReq);

    /**
     * 查询租户下备注对应的事件id
     *
     * @param tenantId 租户id
     * @param remark 备注
     * @return 返回对象
     */
    List<String> queryEventIdList(String tenantId, String remark);

    /**
     * 根据父级id查询子模板数量
     *
     * @param parentId 父级id
     * @return 返回
     */
    Long queryChildTemplateCount(Long parentId);

    /**
     * 复制模板
     *
     * @param copyTemplateReq 请求参数
     */
    void copyTemplate(CopyTemplateReq copyTemplateReq);
}
