package com.digiwin.athena.semc.service.message;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.message.*;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.entity.message.ThirdMessageType;
import com.digiwin.athena.semc.vo.message.MessageAppNumResp;
import org.springframework.http.ResponseEntity;

import java.util.List;

/**
 * @description: 三方异构系统消息接入
 * @createDate: 2024/3/4
 * @author: sungqz
 */
public interface ThirdSystemMessageService extends IService<ThirdMessageConfig> {

    /**
     * 根据应用code查询当前应用的配置
     *
     * @param appCode 应用code
     * @param appId 应用appId
     * @return
     */
    List<ThirdMessageConfig> queryConfigByAppCode(String appCode,String appId);

    /**
     * 查询异构系统的消息配置
     *
     * @param queryImportRecordReq 查询参数
     * @return
     */
    PageInfoResp<ThirdMessageConfig> queryMessageConfigPage(QueryThirdMessageConfigReq queryImportRecordReq);

    /**
     * 校验应用是否已经存在
     *
     * @param saveThirdMessageConfigReq 请求入参
     * @return
     */
    boolean validMessageConfigExist(SaveThirdMessageConfigReq saveThirdMessageConfigReq);

    /**
     * 新增异构系统的消息配置
     *
     * @param saveThirdMessageConfigReq 请求参数
     */
    ThirdMessageConfig saveApplication(SaveThirdMessageConfigReq saveThirdMessageConfigReq);

    /**
     * 接收异构系统的消息推送 restful接口
     *
     * @param receiveThirdMessageReq 请求入参
     */
    void receiveMessage(ReceiveThirdMessageReq receiveThirdMessageReq);

    /**
     * 查询消息的未读数量，在首页小铃铛展示
     */
    Long queryUnreadCount(Integer clientType);

    /**
     * 查询消息列表
     *
     * @param queryThirdMessageListReq 请求入参
     * @return 返回对象
     */
    PageInfoResp<ThirdMessageInfo> queryMessageListPage(QueryThirdMessageListReq queryThirdMessageListReq);

    /**
     * 读取消息，记录为已读消息
     *
     * @param readThirdMessageReq 请求入参
     */
    void readMessage(ReadThirdMessageReq readThirdMessageReq);

    /**
     * 删除应用的消息配置
     *
     * @param deleteMessageConfigReq 请求参数
     */
    void deleteBatchApp(DeleteMessageConfigReq deleteMessageConfigReq);

    ResponseEntity<?> syncMessageData();

    /**
     * 记录用户全部为已读消息
     *
     */
    ResponseEntity<BaseResultDTO<Integer>>  readAllMessage(QueryThirdMessageListReq queryThirdMessageListReq);

    /**
     * 查询消息所属应用列表
     *
     * @param queryThirdMessageListReq 请求对象
     * @return 返回
     */
    List<MessageAppNumResp> queryMessageAppList(QueryThirdMessageListReq queryThirdMessageListReq);

    /**
     * 查询消息分类列表
     *
     * @return 返回
     */
    List<ThirdMessageType> queryMessageType();

    /**
     * 保存用户的消息应用展示顺序
     *
     * @param appIdList 应用id列表
     * @return 返回
     */
    Boolean saveAppSort(List<String> appIdList);

    /**
     * 查询消息数量
     *
     * @param queryThirdMessageListReq 请求入参
     * @return 返回对象
     */
    MessageAppNumResp queryMessageCount(QueryThirdMessageListReq queryThirdMessageListReq);

}
