package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.message.MessageChannelBase;
import com.digiwin.athena.semc.mapper.message.MessageChannelBaseMapper;
import com.digiwin.athena.semc.service.message.MessageChannelBaseService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;


/**
 * 消息发送渠道基础表(TMessageChannelBase)表服务实现类
 *
 * @author sungqz
 * @since 2023-12-05
 */
@Service
public class MessageChannelBaseServiceImpl extends ServiceImpl<MessageChannelBaseMapper, MessageChannelBase> implements MessageChannelBaseService {

    @Resource
    private MessageChannelBaseMapper messageChannelBaseMapper;

    /**
     * 查询消息发送渠道基础配置
     *
     * @return 返回对象
     */
    public List<MessageChannelBase> queryBaseChannel() {
        List<MessageChannelBase> channelBaseList = messageChannelBaseMapper.selectList(Wrappers.emptyWrapper());
        if (CollectionUtils.isEmpty(channelBaseList)) {
            return channelBaseList;
        }
        // 繁体语系需要翻译
        String locale = LocaleContextHolder.getLocale().toString();
        if (Constants.ZH_TW_LOCALE.equals(locale)) {
            channelBaseList.forEach(x -> x.setChannelValue(x.getChannelValueTw()));
        }
        return channelBaseList;
    }
}
