package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.message.MessageChannel;
import com.digiwin.athena.semc.mapper.message.MessageChannelMapper;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import com.digiwin.athena.semc.service.message.MessageChannelService;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 消息发送渠道表(TMessageChannel)表服务实现类
 *
 * @author sungqz
 * @since 2023-11-30
 */
@Service
public class MessageChannelServiceImpl extends ServiceImpl<MessageChannelMapper, MessageChannel> implements MessageChannelService {

    @Resource
    private MessageChannelMapper messageChannelMapper;

    @Resource
    private AimService aimService;

    /**
     * 消息渠道应用级别 1:租户级 2:用户级
     */
    public static final int CHANNEL_LEVEL_TENANT = 1;

    /**
     * 消息渠道应用级别 1:租户级 2:用户级
     */
    public static final int CHANNEL_LEVEL_USER = 2;

    /**
     * 查询租户的消息发送渠道
     *
     * @param userId 用户id
     * @return 查询结果
     */
    @Override
    public MessageChannel queryChannel(String userId, String tenantId) {
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        int channelLevel = StringUtils.isNotBlank(userId) ? CHANNEL_LEVEL_USER : CHANNEL_LEVEL_TENANT;
        return messageChannelMapper.queryChannelByCondition(tenantId, userId, channelLevel);
    }

    @Override
    public String queryChannelFlag(String userId, String tenantId) {
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        int channelLevel = StringUtils.isNotBlank(userId) ? CHANNEL_LEVEL_USER : CHANNEL_LEVEL_TENANT;
        String result= messageChannelMapper.queryChannelFlagByCondition(tenantId, userId, channelLevel);
        if (StringUtils.isBlank(result)) {
            return "";
        }
        return result;
    }

    /**
     * 保存租户的消息发送渠道
     *
     * @param channelStr 渠道
     * @return 返回对象
     */
    @Override
    public Long saveChannel(String channelStr) {
        MessageChannel messageChannel = queryChannel(null, "");
        // 不存在则是首次设置
        if (messageChannel == null) {
            messageChannel = new MessageChannel();
            messageChannel.setChannelFlag(channelStr);
            messageChannelMapper.insert(messageChannel);
            aimService.removeMessageChannel(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            return messageChannel.getId();
        } else {
            messageChannel.setChannelFlag(channelStr);
            messageChannelMapper.updateById(messageChannel);
            aimService.removeMessageChannel(messageChannel.getTenantId());
            return messageChannel.getId();
        }
    }
}
