package com.digiwin.athena.semc.service.mobile;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.entity.mobile.MobileDataSourceAuth;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthListResp;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthQueryReq;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthSaveReq;

import java.util.List;

public interface MobileDataSourceAuthService extends IService<MobileDataSourceAuth> {

    /**
     * 保存应用作业权限
     * @param req
     * @return
     */
    Integer saveDatasourceAuth(MobileDataSourceAuthSaveReq req);


    /**
     *查询应用作业权限配置列表
     * @param req
     * @return
     */
    List<MobileDataSourceAuthListResp> queryAuthList(MobileDataSourceAuthQueryReq req);

    /**
     * 查询登录用户权限内的移动应用作业权限
     * @return
     */
    List<Long> selectUserAuth();
}
