package com.digiwin.athena.semc.service.mobile;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.vo.mobile.MobileClassificatonResp;

import java.util.List;

/**
 * 自定义应用分类服务接口层
 * @author qutong
 * @since 2024-09-03
 */
public interface MobileDatasourceClassificationService extends IService<MobileDatasourceClassification> {

    /**
     * 查询应用分类
     *
     * @return 返回
     */
    List<MobileDatasourceClassification> queryApplicationClassificationList();

    /**
     * 判断名称是否重复
     *
     * @param id 主键id
     * @param name 公告类型名称
     * @return 返回
     */
    List<MobileDatasourceClassification> existNameValid(Long id, String name);

    /**
     * 删除自定义类型
     *
     * @param id 主键id
     */
    void delApplicationClassification(Long id);

    /**
     * 查询应用分类及其应用
     * @param isAll 是否需要查询全部的数据，true：查询所有分类，false：需要根据用户已选的分类过滤
     * @return
     */
    List<MobileClassificatonResp> getClassificationList(Boolean isAll);

    /**
     * 默认门户
     * 查询应用分类及其应用
     * @param isAll 是否需要查询全部的数据，true：查询所有分类，false：需要根据用户已选的分类过滤
     * @return
     */
    List<MobileClassificatonResp> getClassificationListNew(Boolean isAll);

    /**
     * 保存自定义应用分类
     * @param mobileDatasourceClassification 入参
     * @return 返回
     */
    void saveClassification(MobileDatasourceClassification mobileDatasourceClassification);
}
