package com.digiwin.athena.semc.service.mobile;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.dto.mobile.SaveAppcationReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationConfigReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationStatusReq;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.mobile.MobileDatasourceInfoVO;

import java.util.List;

/**
 * 自定义应用服务接口
 *
 * @author qutong
 * @since 2024-09-03
 */
public interface MobileDatasourceInfoService extends IService<MobileDatasourceInfo> {

    /**
     * 分页查询移动应用/作业列表
     *
     * @param customApplicationsListPageReq 查询参数
     * @return 返回
     */
    PageInfoResp<MobileDatasourceInfoVO> queryCustomApplicationsByPage(CustomApplicationsListPageReq customApplicationsListPageReq);

    /**
     * 更新启用状态
     *
     * @param updateAppcationStatusReq 入参
     */
    void updateStatus(UpdateAppcationStatusReq updateAppcationStatusReq);


    /**
     * 删除移动应用/作业信息
     *
     * @param idList id列表
     */
    void delApplicationInfo(List<Long> idList);

    /**
     * 查询移动应用/作业详情
     *
     * @param id 主键id
     * @return 返回
     */
    MobileDatasourceInfoVO queryCustomApplicationDetail(Long id);

    /**
     * 保存移动应用/作业管理数据
     *
     * @param saveAppcationReq 入参
     * @return 返回
     */
    void saveCustomApplication(SaveAppcationReq saveAppcationReq);

    /**
     * 校验名称
     *
     * @param saveAppcationReq 入参
     * @return 返回
     */
    Integer countByParam(SaveAppcationReq saveAppcationReq);

    /**
     * 移动门户所需数据源配置信息查询
     * @param customApplicationReq
     * @return
     */
    List<MobileDatasourceInfo> queryDatasourceInfo(CustomApplicationsListPageReq customApplicationReq);

    /**
     * 根据租户查询dap商品应用信息
     * @return
     */
    List<UserApplicationSimpleDTO> queryApplicationByUser();

    /**
     * 根据dap商品应用查询模组信息
     * 该方法后台不调用了
     * @return
     */
    List<UserApplicationModulesDTO> queryModuleByApplication(PermissionUserFunctionalDTO permissionUserFunctionalDTO);

    /**
     * 根据商品应用及模组信息查询作业信息
     * @return
     */
    List<PermissionUserFunctionalDTO> queryWorkByApplication(PermissionUserFunctionalDTO permissionUserFunctionalDTO);

    /**
     * 关联配置
     * @param updateAppcationConfigReq
     */
    void updateConfig(UpdateAppcationConfigReq updateAppcationConfigReq);
}
