package com.digiwin.athena.semc.service.mobile;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReq;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReqNew;
import com.digiwin.athena.semc.dto.mobile.MobileSSOReq;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.vo.mobile.*;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import org.springframework.http.ResponseEntity;

import java.util.List;

public interface MobilePortalService extends IService<MobilePortalInfo> {

    /**
     * 获取移动门户详情
     *
     * @param id
     * @param scene
     * @return
     */
    MobilePortalInfoResp getPortalInfo(Long id, Integer scene);

    /**
     * 查询用户移动门户列表
     *
     * @return
     */
    List<MobilePortalInfoItemResp> selectUserPortal();

    /**
     * 获取门户详情
     *
     * @param mobilePortalInfoResp
     * @return
     */
    MobilePortalInfoResp getPortalDetail(MobilePortalInfoResp mobilePortalInfoResp);


    /**
     * 条件查询
     *
     * @param req
     * @return
     */
    List<MobilePortalInfo> checkPortal(MobilePortalInfo req);

    /**
     * 保存
     *
     * @param req
     * @return
     */
    MobilePortalInfo savePortal(MobilePortalInfo req);

    /**
     * 复制门户
     *
     * @param req
     * @return
     */
    Integer copyPortal(MobilePortalInfo req);


    /**
     * 分页查询门户列表
     *
     * @param req
     * @return
     */
    ResultPageBean pageQuery(PortalInfoQueryReq req);


    /**
     * 批量更新
     *
     * @param req
     * @return
     */
    Integer updateBat(PortalInfoQueryReq req);

    /**
     * 批量删除
     *
     * @param req
     * @return
     */
    Integer delBat(PortalInfoQueryReq req);

    /**
     * 保存权限
     *
     * @param req
     * @return
     */
    Integer savePortalAuth(PortalInfoAuthReq req);

    /**
     * 获取门户权限信息
     *
     * @param portalId
     * @return
     */
    MobilePortalInfoAuthResp selectByPortalAuth(Long portalId);

    /**
     * 获取移动门户详情
     *
     * @param portalInfo
     * @return
     */
    MobilePortalInfoResp getMobilePortalDetail(MobilePortalInfo portalInfo);

    /**
     * 预览移动门户
     *
     * @param req
     * @return
     */
    MobilePortalPreview previewPortal(MobilePortalInfo req, PortalInfo portalInfo);

    MobilePortalPreview getPreviewPortal(Long id);

    /**
     * 门户预览
     *
     * @param id
     * @return
     */
    MobilePortalInfoResp getPreMobilePortal(Long id);

    /**
     * 保存门户
     *
     * @param typeUse
     * @return
     */

    Boolean saveMobilePortalTypeUse(MobilePortalTypeUse typeUse);

    /**
     * 校验门户信息
     *
     * @param portalInfo
     * @return
     */
    ResponseEntity<?> checkPortalInfo(MobilePortalInfo portalInfo);

    /**
     * 增加使用记录
     *
     * @param portId
     */
    Boolean addUseRecord(Long portId);

    /**
     * 保存应用栏目
     *
     * @param applicationColumnReq
     */
    void saveApplicationColumn(ApplicationColumnReq applicationColumnReq);

    /**
     * /**
     *      * 保存应用栏目
     *      *
     *      * @param applicationColumnReq
     */
    void saveApplicationColumnNew(ApplicationColumnReqNew applicationColumnReqNew);

    /**
     * 查询用户自定义栏目
     *
     * @return
     */
    List<MobileAppColumnResp> getApplicationColumnList();

    /**
     * 查询单个栏目详情
     *
     * @param mobileApplicatonColumn
     * @return
     */
    MobileAppColumnResp getApplicationColumnDetail(MobileApplicatonColumn mobileApplicatonColumn);

    /**
     * 查询单个栏目详情 默认门户
     *
     * @param mobileApplicatonColumn
     * @return
     */
    MobileAppColumnResp getApplicationColumnDetailNew(MobileApplicatonColumnNew mobileApplicatonColumn);

    /**
     * 查询应用列表
     *
     * @param customAppIds
     * @return
     */
    List<MobileDatasourceInfoVO> getCustomApplication(List<Long> customAppIds);

    /**
     * 查询应用列表 默认门户
     * @param customAppIds
     * @return
     */
    List<MobileDatasourceInfoVO> getCustomApplicationNew(List<String> customAppIds);

    /**
     * 调整自定义栏目顺序
     *
     * @param columIds
     */
    void setColumnOrder(List<Long> columIds);

    void setColumnOrderNew(List<Long> columIds);

    /**
     * 删除自定义栏目
     *
     * @param columnIds
     */
    void delColumn(List<Long> columnIds);

    /**
     * 删除自定义栏目 默认门户
     *
     * @param columnIds
     */
    void delColumnNew(List<Long> columnIds);

    /**
     * 获取sso的路径
     *
     * @param mobileSSOReq
     * @return
     */
    FullBackResp getFullCallBackUrl(MobileSSOReq mobileSSOReq);

    /**
     * 校验门户中的组件是否有使用到应用作业
     *
     * @param appIdList
     * @return 门户布局内容
     */
    List<MobilePortalInfoContent> checkContentApp(List<Long> appIdList);


    /**
     * 查询用户自定义栏目  默认门户
     *
     * @return
     */
    List<MobileAppColumnResp> getApplicationColumnListNew();
    /**
     * 请求移动门户列表条件查询
     *
     * @param req 请求对象
     * @return 返回
     */
    List<MobilePortalInfo> getListMobilePortal(PortalInfoQueryReq req);
}
