package com.digiwin.athena.semc.service.mobile;


import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;

import java.util.List;

public interface MobileUserAuthService {


    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param customApplicationIdList 应用id列表
     * @return 返回
     */
    List<Long> validUserAppAuth(List<Long> customApplicationIdList);


    /**
     * 过滤鼎捷雅典娜APP的作业权限，返回有权限的组件ID
     * @param systemDataList 数据源
     * @return 有权限的组件ID
     */
    UserAuthSystemLabelVo buildSystemIdApp(List<LabelSystemData>  systemDataList);


    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param mobileAppList 应用列表
     * @return
     */
    List<Long> validPermission(List<MobileDatasourceInfo> mobileAppList);
}
