package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.mobile.MobileDataSourceAuth;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.mapper.mobile.MobileDataSourceAuthMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.service.mobile.MobileDataSourceAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthListResp;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthQueryReq;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthSaveReq;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Slf4j
public class MobileDataSourceAuthServiceImpl extends ServiceImpl<MobileDataSourceAuthMapper, MobileDataSourceAuth>  implements MobileDataSourceAuthService {

    @Autowired
    private MobileDataSourceAuthMapper mobileDatasourceAuthMapper;

    @Resource
    private MobileDatasourceInfoMapper mobileDatasourceInfoMapper;

    @Autowired
    private LabelSystemAuthService labelSystemAuthService;

    @Resource
    private Converter converter;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer saveDatasourceAuth(MobileDataSourceAuthSaveReq req) {
        List<MobileDataSourceAuth> dataSourceAuthList=selectByParam(req);
        //取消权限
        if(CollectionUtils.isNotEmpty(dataSourceAuthList)){
            List<Long> authIdList=dataSourceAuthList.stream().map(MobileDataSourceAuth::getId).filter(Objects::nonNull).collect(Collectors.toList());
            mobileDatasourceAuthMapper.deleteBatchIds(authIdList);
        }
        //增加权限
        if(CollectionUtils.isNotEmpty(req.getDataSourceList())){
            for(MobileDataSourceAuthListResp dataSourceAuthReq:req.getDataSourceList()){
                //取消选中
                if(!dataSourceAuthReq.getIsRelated()){
                  continue;
                }
                MobileDataSourceAuth dataSourceAuth=converter.convert(req, MobileDataSourceAuth.class);
                dataSourceAuth.setDatasourceId(dataSourceAuthReq.getDataSourceId());
                dataSourceAuth.setTenantId(Utils.getTenantId());
                mobileDatasourceAuthMapper.insert(dataSourceAuth);
            }
        }
        return null;
    }


    /**
     * 条件查询移动应用/作业权限记录
     * @param req
     * @return
     */
    public List<MobileDataSourceAuth>  selectByParam(MobileDataSourceAuthSaveReq req){
        QueryWrapper<MobileDataSourceAuth> queryWrapper = new QueryWrapper<>();
        if(null !=req.getAuthId()){
            queryWrapper.eq("auth_id", req.getAuthId());
        }
        if(null !=req.getAuthSid()){
            queryWrapper.eq("auth_sid", req.getAuthSid());
        }
        if(null !=req.getAuthType()){
            queryWrapper.eq("auth_type",req.getAuthType());
        }
        return  mobileDatasourceAuthMapper.selectList(queryWrapper);
    }


    @Override
    public List<MobileDataSourceAuthListResp> queryAuthList(MobileDataSourceAuthQueryReq req) {
        //查询三方应用的所有移动应用作业列表
        QueryWrapper<MobileDatasourceInfo> condition = new QueryWrapper<>();
        condition.eq("type", Constants.MobileAppJobTypeEnum.THIRD_APP_JOB.getFlag());
        condition.orderByDesc("modify_time");
        if (StringUtils.isNotBlank(req.getName())) {
            condition.like("name", req.getName());
        }
        List<MobileDatasourceInfo> datasourceInfoList=mobileDatasourceInfoMapper.selectList(condition);
        //查询有权限的移动应用作业
        QueryWrapper<MobileDataSourceAuth> authCondition = new QueryWrapper<>();
        authCondition.eq("auth_id", req.getAuthId());
        authCondition.eq("auth_sid", req.getAuthSid());
        List<MobileDataSourceAuth> dataSourceAuthList = mobileDatasourceAuthMapper.selectList(authCondition);
        Map<Long, MobileDataSourceAuth> labelSystemAuthMap =  dataSourceAuthList.stream().collect(Collectors.toMap(MobileDataSourceAuth::getDatasourceId, Function.identity()));
        List<MobileDataSourceAuthListResp> authListRespList=new ArrayList<>();
        for(MobileDatasourceInfo datasourceInfo:datasourceInfoList){
            MobileDataSourceAuthListResp sourceAuthListResp=new MobileDataSourceAuthListResp();
            sourceAuthListResp.setDataSourceId(datasourceInfo.getId());
            sourceAuthListResp.setDataSourceName(datasourceInfo.getName());
            sourceAuthListResp.setValidStatus(datasourceInfo.getStatus());
            Boolean isRelated = labelSystemAuthMap.get(datasourceInfo.getId()) == null ? false : true;
            sourceAuthListResp.setIsRelated(isRelated);
            authListRespList.add(sourceAuthListResp);
        }
        return authListRespList;
    }

    @Override
    public List<Long> selectUserAuth() {
        QueryWrapper<MobileDataSourceAuth> condition = new QueryWrapper<>();
        List<MobileDataSourceAuth>  dataSourceAuthList=mobileDatasourceAuthMapper.selectList(labelSystemAuthService.getUserAuthSidCon(condition));
        List<Long> dataSourceIdList=dataSourceAuthList.stream().map(MobileDataSourceAuth::getDatasourceId).filter(Objects::nonNull).collect(Collectors.toList());
        return dataSourceIdList;
    }
}
