package com.digiwin.athena.semc.service.mobile.impl;


import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.MobileLabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.mobile.MobileLabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.mapper.mobile.MobileLabelSystemPreMapper;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.mobile.MobileLabelSystemPreService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
@Slf4j
public class MobileLabelSystemPreServiceImpl implements MobileLabelSystemPreService {

    @Autowired
    private MobileLabelSystemPreMapper mobileLabelSystemPreMapper;

    @Resource
    private LabelSystemPreService labelSystemPreService;

    @Resource
    private TranslateService translateService;


    @Override
    public List<MobileLabelSystemPre> initMobileLabelSystemPre() {
        //查询租户的数据
        List<MobileLabelSystemPre> labelSystemPreList = mobileLabelSystemPreMapper.querySystemPre(Utils.getTenantId());
        //查询全局预设组件信息
        List<MobileLabelSystemPre> overSystemPreList = mobileLabelSystemPreMapper.querySystemPre("");
        //待插入的预设组件
        List<MobileLabelSystemPre> insertPreList = new ArrayList<>();
        //该租户下没有预设组件，初始化全局的组件给该租户
        if (CollectionUtils.isEmpty(labelSystemPreList)) {
            insertPreList.addAll(overSystemPreList);
        } else {
            //比较数据库预设和租户下的预设组件，将新增的初始化
            //将租户下预设组件的数据转map
            Map<Integer, MobileLabelSystemPre> preListMap = labelSystemPreList.stream()
                    .collect(Collectors.toMap(MobileLabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));

            for (MobileLabelSystemPre overSystemPre : overSystemPreList) {
                //如果租户的组件中没有该全局的组件，则需要插入
                if (null == preListMap.get(overSystemPre.getDataCategory())) {
                    insertPreList.add(overSystemPre);
                }
            }
        }
        //初始化租户的预设组件数据
        if (CollectionUtils.isNotEmpty(insertPreList)) {
            labelSystemPreList = batchSavePreData(insertPreList, Utils.getTenantId());
        }
        //查询租户的数据
        labelSystemPreList = mobileLabelSystemPreMapper.querySystemPre(Utils.getTenantId());
        return labelSystemPreList;

    }

    /**
     * 批量新增预设组件
     *
     * @param insertPreList
     * @param tenantId
     * @return
     */
    private List<MobileLabelSystemPre> batchSavePreData(List<MobileLabelSystemPre> insertPreList, String tenantId) {
        List<MobileLabelSystemPre> systemPreTenantList = new ArrayList<>();
        for (MobileLabelSystemPre labelSystemPre : insertPreList) {
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            labelSystemPre.setCreateTime(DateUtils.getNowTime(""));
            labelSystemPre.setModifyTime(DateUtils.getNowTime(""));
            mobileLabelSystemPreMapper.insert(labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }


    @Override
    public ResultPageBean pageQuery(MobileLabelSystemPreQueryReq req) {
        List<MobileLabelSystemPre> labelSystemPreList = initMobileLabelSystemPre();
        if (CollectionUtils.isNotEmpty(req.getDataCategory())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> req.getDataCategory().contains(x.getDataCategory())).collect(Collectors.toList());
        }
        if (null != req.getValidStatus()) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> req.getValidStatus().equals(x.getValidStatus())).collect(Collectors.toList());
        }
        for (MobileLabelSystemPre labelSystemPre : labelSystemPreList) {
            String name = translateService.translateTextCache(labelSystemPre.getName(), StringUtils.EMPTY);
            labelSystemPre.setName(name);
            labelSystemPre.setModifyUserId("");
            labelSystemPre.setModifyUserName("");
        }
        if (StringUtils.isNotEmpty(req.getName())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(req.getName())).collect(Collectors.toList());
        }
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemPreList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), labelSystemPreList.size())));
        return resultPageBean;
    }

    @Override
    public List<LabelSystemPre> getAllSystemPre(MobileLabelSystemPreQueryReq req) {
        List<LabelSystemPre> labelSystemPreList = labelSystemPreService.initPreData(Constants.ClientTypeEnum.MOBILE.getValue());
        for (LabelSystemPre labelSystemPre : labelSystemPreList) {
            String name = translateService.translateTextCache(labelSystemPre.getName(), StringUtils.EMPTY);
            labelSystemPre.setName(name);
        }
        if (StringUtils.isNotEmpty(req.getName())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(req.getName())).collect(Collectors.toList());
        }
        return labelSystemPreList;
    }
}
