package com.digiwin.athena.semc.service.mobile.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.TWAppUrlVariableEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.*;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.entity.portal.PortalInfoAuth;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.entity.portal.*;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.*;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.service.mobile.MobileLabelSystemPreService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.sso.IMobileSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.*;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.Collator;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
@Slf4j
public class MobilePortalServiceImpl extends ServiceImpl<MobilePortalInfoMapper, MobilePortalInfo> implements MobilePortalService {

    @Autowired
    private MobilePortalInfoMapper mobilePortalInfoMapper;

    @Autowired
    private MobilePortalInfoContentMapper mobilePortalInfoContentMapper;

    @Autowired
    private MobilePortalInfoAuthMapper mobilePortalInfoAuthMapper;

    @Autowired
    private LabelSystemAuthService labelSystemAuthService;

    @Resource
    private TranslateService translateService;

    @Autowired
    private MobileLabelSystemPreService mobileLabelSystemPreService;

    @Autowired
    private IMobileSsoInfoService mobileSsoInfoService;

    @Autowired
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;

    @Autowired
    private MobileLabelSystemPreMapper mobileLabelSystemPreMapper;

    @Autowired
    private MobilePortalPreviewMapper mobilePortalPreviewMapper;

    @Resource
    MessageUtils messageUtils;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;

    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;

    @Resource
    private MobileApplicatonColumnNewMapper mobileApplicatonColumnNewMapper;


    @Resource
    private MobileDatasourceInfoMapper mobileCustomApplicationMapper;

    @Resource
    private MobileDatasourceClassificationMapper mobileDatasourceClassificationMapper;

    @Resource
    private SyncJobInfoMapper syncJobInfoMapper;

    @Autowired
    private KmService kmService;

    @Resource
    private IamService iamService;

    @Autowired
    MayCurService mayCurService;

    @Autowired
    EocService eocService;

    @Autowired
    TopicPresetService topicPresetService;

    @Autowired
    MobileUserAuthService mobileUserAuthService;

    @Resource
    private Converter converter;

    @Resource
    private MobileDatasourceClassificationMapper mobileApplicationClassificationMapper;

    @Override
    public MobilePortalInfoResp getPortalInfo(Long id, Integer scene) {

        MobilePortalInfoResp result = new MobilePortalInfoResp();
        MobilePortalInfo mobilePortalInfo = mobilePortalInfoMapper.selectOne(new LambdaUpdateWrapper<MobilePortalInfo>()
                .eq(MobilePortalInfo::getId, id));

        if (ObjectUtils.isEmpty(mobilePortalInfo)) {
            return result;
        }
        if(null != mobilePortalInfo.getDefaultFlag() && 1 == mobilePortalInfo.getDefaultFlag()){
            mobilePortalInfo.setVersionDefault(1);
        }
        converter.convert(mobilePortalInfo, result);

        LambdaQueryWrapper<MobilePortalInfoContent> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MobilePortalInfoContent::getMobilePortalId, id);
        List<MobilePortalInfoContent> mobilePortalInfoContents = new ArrayList<>();
        List<MobilePortalInfoContent> mobilePortalInfoContentsSql = mobilePortalInfoContentMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(mobilePortalInfoContentsSql)) {
            mobilePortalInfoContents = mobilePortalInfoContentsSql;
        }
        List<MobilePortalInfoContentResp> mobilePortalInfoContentResps = new ArrayList<>();
        //父亲id
        Map<Long, List<BallResp>> ballListMap = new HashMap<>();
        //生成金刚球 Map
        mobilePortalInfoContents.stream().filter(x -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType())).forEach(x -> {
            BallResp ballResp = BallResp.builder().ballName(x.getContentName()).iconType(x.getIconType())
                    .contentIcon(StringUtils.isNotEmpty(x.getContentIcon()) ? x.getContentIcon() : Constants.CONTENT_ICON_DEF)
                    .jumpTarget(x.getJumpTarget()).jumpType(x.getJumpType()).customApplicationId(x.getCustomApplicationId()).createUserId(x.getCreateUserId()).build();
            // 构建跳转链接
            if (ObjectUtils.isNotEmpty(x.getIconType())) {
                if (x.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    ballResp.setIconUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + ballResp.getContentIcon());
                } else if (x.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    ballResp.setIconUrl(envProperties.getSemcWebUrl() + ballResp.getContentIcon());
                }
            }
            if (ballListMap.containsKey(x.getParentId())) {
                List<BallResp> ballResps = ballListMap.get(x.getParentId());
                ballResps.add(ballResp);
            } else {
                List<BallResp> ballResps = new ArrayList<>();
                ballResps.add(ballResp);
                ballListMap.put(x.getParentId(), ballResps);
            }
        });
        if (CollectionUtils.isEmpty(mobilePortalInfoContents)) {
            return result;
        }
        for (MobilePortalInfoContent content : mobilePortalInfoContents) {
            //金刚球
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType())) {
                continue;
            }
            MobilePortalInfoContentResp mobilePortalInfoContentResp = converter.convert(content, MobilePortalInfoContentResp.class);
            //如果是金刚区则添加相关的金刚球
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(mobilePortalInfoContentResp.getContentType())) {
                if (Constants.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(mobilePortalInfoContentResp.getCustomType())) {
                    List<BallResp> ballResps = ballListMap.get(content.getId());
                    // 过滤出有权限的应用列表
                    List<BallResp> ballAuthResp = filterPermissionBallList(ballResps);
                    mobilePortalInfoContentResp.setBallList(ballAuthResp);
                    mobilePortalInfoContentResps.add(mobilePortalInfoContentResp);
                }
                if (Constants.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(mobilePortalInfoContentResp.getCustomType())) {
                    mobilePortalInfoContentResps.addAll(buildColumnDistrict(mobilePortalInfoContentResp));
                }
                continue;
            } //组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(content.getContentAttr(), MobilePortalContentCarousel.class);
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    String icon = image.getContentIcon();
                    //处理图标-图标库
                    if (null != image.getImgType()
                            && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                            && StringUtils.isNotEmpty(icon)
                    ) {
                        icon = envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                content.setCarouselInfo(carouselInfo);
                mobilePortalInfoContentResp.setCarouselInfo(carouselInfo);
            }
            //组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                MobilePortalContentNews newsInfo = JSON.parseObject(content.getContentAttr(), MobilePortalContentNews.class);
                if (null != newsInfo) {
                    if (newsInfo.getNewsLikeCountFlag() == null) {
                        newsInfo.setNewsLikeCountFlag(0);
                    }
                    //如果选择的是二级，是以逗号分隔，则取第一个值作为一级公告类型ID，第二个值作为二级公告类型ID
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",")) {
                        String[] newsTypeIds = newsInfo.getNewsTypeIdStr().split(",");
                        if (newsTypeIds.length >= 2) {
                            newsInfo.setChildrenNewsTypeId(Integer.parseInt(newsTypeIds[1]));
                            newsInfo.setNewsTypeId(Integer.parseInt(newsTypeIds[0]));
                        }
                    }
                    //只有一级
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                        newsInfo.setNewsTypeId(Integer.parseInt(newsInfo.getNewsTypeIdStr()));
                    }
                    mobilePortalInfoContentResp.setNewsInfo(newsInfo);
                }
            }
            //组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(content.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                //如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() &&
                        titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + iconUrl;
                }
                //如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                mobilePortalInfoContentResp.setTitleInfo(titleInfo);
            }
            // 组装分割线
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = JSON.parseObject(content.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                mobilePortalInfoContentResp.setDividerInfo(dividerInfo);
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + imageCompInfo.getImageId());
                }
                mobilePortalInfoContentResp.setImageCompInfo(imageCompInfo);
            }
            //业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        String imageUrl = StringUtils.isEmpty(image.getImageId()) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + image.getImageId();
                        image.setImageUrl(imageUrl);
                    }
                }
                mobilePortalInfoContentResp.setBusinessCompInfo(businessCompInfo);
            }
            mobilePortalInfoContentResps.add(mobilePortalInfoContentResp);
        }
        result.setContentList(mobilePortalInfoContentResps);
        return result;
    }

    /**
     * 过滤出有权限的应用列表
     *
     * @param ballResps 应用列表
     * @return 返回
     */
    private List<BallResp> filterPermissionBallList(List<BallResp> ballResps) {
        // 不是自定义应用类型的金刚球不参与校验
        List<Long> notCustomApplicationIdList = ballResps.stream().filter(x -> !Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        // 过滤出自定义应用，校验当前用户是否有应用权限
        List<Long> customApplicationIdList = ballResps.stream().filter(x -> Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        List<Long> withPermissionList = mobileUserAuthService.validUserAppAuth(customApplicationIdList);

        // 最终应用权限列表
        return ballResps.stream().filter(x -> notCustomApplicationIdList.contains(x.getCustomApplicationId())
                || withPermissionList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
    }

    /**
     * 组装自定义金刚区
     *
     * @param mobilePortalInfoContentResp
     * @return
     */
    private List<MobilePortalInfoContentResp> buildColumnDistrict(MobilePortalInfoContentResp mobilePortalInfoContentResp) {
        List<MobilePortalInfoContentResp> result = new ArrayList<>();
        String userId = Utils.getUserId();
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, userId).eq(MobileApplicatonColumn::getStatus, Constants.VALID_STATUS_ENABLE)
                .orderByAsc(MobileApplicatonColumn::getOrderId).orderByAsc(MobileApplicatonColumn::getId);
        //查询自定义栏目
        List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
        //自定义应用栏目map
        Map<Long, List<MobileApplicatonColumn>> appMap = mobileApplicatonColumns.stream().filter(x -> !ObjectUtils.isEmpty(x.getParentId()))
                .collect(Collectors.groupingBy(MobileApplicatonColumn::getParentId));
        List<Long> customAppIds = mobileApplicatonColumns.stream().filter(x -> ObjectUtils.isNotEmpty(x.getCustomApplicationId())).map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        //查询自定义应用
        Map<Long, MobileDatasourceInfo> customAppMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            List<MobileDatasourceInfo> mobileDatasourceInfos = mobileCustomApplicationMapper.selectList(new LambdaQueryWrapper<MobileDatasourceInfo>().eq(MobileDatasourceInfo::getStatus, Constants.VALID_STATUS_ENABLE).in(MobileDatasourceInfo::getId, customAppIds));
            customAppMap = mobileDatasourceInfos.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, Function.identity()));
        }

        //遍历自定义应用栏
        for (MobileApplicatonColumn mobileApplicatonColumn : mobileApplicatonColumns) {
            if (ObjectUtils.isNotEmpty(mobileApplicatonColumn.getParentId()) || ObjectUtils.isNotEmpty(mobileApplicatonColumn.getCustomApplicationId())) {
                continue;
            }
            MobilePortalInfoContentResp resp = new MobilePortalInfoContentResp();
            resp.setColumnId(mobileApplicatonColumn.getId());
            resp.setContentId(mobilePortalInfoContentResp.getContentId());
            resp.setContentType(Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal());
            resp.setParentId(mobilePortalInfoContentResp.getContentId());
            resp.setContentName(mobileApplicatonColumn.getName());
            resp.setContentUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            resp.setTitle(mobileApplicatonColumn.getName());
            resp.setIsTitleShow(mobileApplicatonColumn.getIsNameShow());
            resp.setIsNameShow(mobilePortalInfoContentResp.getIsNameShow());
            resp.setInteractionType(mobilePortalInfoContentResp.getInteractionType());
            resp.setCustomType(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue());
            resp.setColumnNum(mobilePortalInfoContentResp.getColumnNum());
            resp.setLineNum(mobilePortalInfoContentResp.getLineNum());
            List<BallResp> ballRespList = new ArrayList<>();
            if (appMap.containsKey(mobileApplicatonColumn.getId())) {
                List<MobileApplicatonColumn> columns = appMap.get(mobileApplicatonColumn.getId());
                for (MobileApplicatonColumn column : columns) {
                    MobileDatasourceInfo mobileDatasourceInfo;
                    Long customApplicationId = column.getCustomApplicationId();
                    if (customAppMap.containsKey(customApplicationId)) {
                        mobileDatasourceInfo = customAppMap.get(customApplicationId);
                    } else {
                        continue;
                    }
                    BallResp ballResp = new BallResp();
                    ballResp.setBallName(mobileDatasourceInfo.getName());
                    ballResp.setJumpType(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue());
                    ballResp.setJumpTarget(ObjectUtils.isEmpty(mobileDatasourceInfo.getCallBackUrl()) ? "" : mobileDatasourceInfo.getCallBackUrl());
                    String icon = mobileDatasourceInfo.getIcon();
                    //处理图标-图标库
                    if (null != mobileDatasourceInfo.getIconType()
                            && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = envProperties.getSemcWebUrl() + icon;
                    }
                    //处理图标-自定义
                    if (null != mobileDatasourceInfo.getIconType()
                            && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + icon;
                    }
                    ballResp.setIconUrl(icon);
                    ballResp.setCustomApplicationId(Long.valueOf(customApplicationId));
                    ballRespList.add(ballResp);
                }
            }
            resp.setBallList(ballRespList);
            result.add(resp);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(mobilePortalInfoContentResp);
            return result;
        }
        // 过滤出有权限的应用列表
        List<BallResp> ballList = Lists.newArrayList();
        result.forEach(x -> ballList.addAll(x.getBallList()));
        List<BallResp> withPermissionList = filterPermissionBallList(ballList);
        List<Long> customApplicationIdList = withPermissionList.stream().map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        for (MobilePortalInfoContentResp portalInfoContentResp : result) {
            List<BallResp> resultBallList = portalInfoContentResp.getBallList().stream().filter(x -> customApplicationIdList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
            portalInfoContentResp.setBallList(resultBallList);
        }
        return result;
    }

    @Override
    public List<MobilePortalInfoItemResp> selectUserPortal() {
        QueryWrapper<MobilePortalInfoAuth> wrapper = new QueryWrapper<>();
        //获取登录用户权限内门户
        List<MobilePortalInfoAuth> mobilePortalInfoAuths = mobilePortalInfoAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(wrapper));
        //查询租户移动端的默认门户
        MobilePortalInfo mobilePortalInfo = initMobileDefPortal();
        //返回值
        List<MobilePortalInfoItemResp> result = new ArrayList<>();
        //默认门户对应的返回数据
        MobilePortalInfoItemResp defPortalItem = converter.convert(mobilePortalInfo, MobilePortalInfoItemResp.class);
        //翻译
//        String name = translateService.translateTextCache(defPortalItem.getName(), StringUtils.EMPTY);
        defPortalItem.setName(defPortalItem.getName());
        //将默认门户加入职能门户列表
        //权限内没有门户，返回默认门户
        if (CollectionUtils.isEmpty(mobilePortalInfoAuths)) {
            result.add(defPortalItem);
            return result;
        }
        //将有权限的门户id筛选出来
        List<Long> portalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
        //查询对应的门户
        List<MobilePortalInfo> portalInfoList = mobilePortalInfoMapper.selectBatchIds(portalIds);
        portalIds.add(mobilePortalInfo.getId());
        //返回已经启用的门户布局
        portalInfoList = portalInfoList.stream()
                .filter(x -> Constants.ReleaseEnum.RELEASED.getVal().equals(x.getStatus()))
                .filter(x -> Constants.MobilePortalTypeEnum.PORTAL.getFlag().equals(x.getPortalType()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portalInfoList)) {
            result.add(defPortalItem);
            return result;
        }
        result.add(defPortalItem);
        Comparator<Object> cmp = Collator.getInstance(Locale.CHINA);
        //按照首字母排序
        portalInfoList.sort((a, b) -> cmp.compare(a.getName(), b.getName()));
        for (int i = 0; i < portalInfoList.size(); i++) {
            MobilePortalInfoItemResp item = converter.convert(portalInfoList.get(i), MobilePortalInfoItemResp.class);
            result.add(item);
        }
        return result;
    }

    @Override
    @Transactional
    public MobilePortalInfoResp getPortalDetail(MobilePortalInfoResp mobilePortalInfoResp) {
        List<MobilePortalInfoContentResp> contentRespList = mobilePortalInfoResp.getContentList();
        //非默认布局，需要校验用户是否有该门户权限
        if (mobilePortalInfoResp.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {
            QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
            //获取登录用户权限内门户
            List<MobilePortalInfoAuth> portalInfoAuthList = mobilePortalInfoAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(condition));
            List<Long> portalIds = portalInfoAuthList.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            String recentlyMsg = "";
            //判断门户是否在权限内，不在则组装提示语
            if (!portalIds.contains(mobilePortalInfoResp.getId())) {
                recentlyMsg = messageUtils.getMessage("error.message.not.auth");
                if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                    recentlyMsg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
                }
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return mobilePortalInfoResp;
            }
        }
        //查询内容信息
        if (CollectionUtils.isEmpty(contentRespList)) {
            //记录用户使用门户记录
//            addUseRecord(mobilePortalInfoResp.getId());
            return mobilePortalInfoResp;
        }
        Map<Long, MobileLabelSystemPre> preInfoMap = new HashMap<>();
        //预设组件
        List<MobilePortalInfoContentResp> preDataList =
                contentRespList.stream().filter(item ->
                                Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(item.getContentType())
                                        || Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(item.getContentType())
                                        || Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(item.getContentType()))
                        .collect(Collectors.toList());


        if (CollectionUtils.isNotEmpty(preDataList)) {
            List<Long> preIds = preDataList.stream().map(MobilePortalInfoContentResp::getContentId).collect(Collectors.toList());
            List<MobileLabelSystemPre> preList = mobileLabelSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }


        //组装图标和类型，名称翻译
        for (MobilePortalInfoContentResp content : contentRespList) {
            //预设组件
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType()) ||
                    Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(content.getContentType()) ||
                    Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(content.getContentType())) {
                MobileLabelSystemPre mobileLabelSystemPre = preInfoMap.get(content.getContentId());
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? mobileLabelSystemPre.getName() : content.getContentName());
            }
            if (StringUtils.isNotEmpty(content.getContentName())) {
                content.setContentName(content.getContentName());
            }
        }
        mobilePortalInfoResp.setContentList(contentRespList);
        return mobilePortalInfoResp;
    }

    @Transactional
    public MobilePortalInfo initMobileDefPortal() {
        //先查询租户默认布局是否存在
        MobilePortalInfo defPortalTent = mobilePortalInfoMapper.queryMobileTentDefPortal();
        //查询全局的通用布局
        MobilePortalInfo defPortal = mobilePortalInfoMapper.queryMobileDefPortal();
        //已存在，则更新
        if (null != defPortalTent) {
            defPortalTent.setPortalImgId(defPortal.getPortalImgId());
            mobilePortalInfoMapper.updateById(defPortalTent);
        } else {
            MobilePortalInfo newDefPortalTent = new MobilePortalInfo();
            BeanUtils.copyProperties(defPortal, newDefPortalTent);
            newDefPortalTent.setId(null);
            mobilePortalInfoMapper.insert(newDefPortalTent);
            defPortalTent = newDefPortalTent;
        }
        //查询全局默认门户配置的组件
        List<Integer> contentTypeList = new ArrayList<>();
        List<MobilePortalInfoContent> contentList = mobilePortalInfoContentMapper.queryMobiePortalCont(defPortalTent.getId(), contentTypeList);
        //查询预设租户下的预设组件
        List<MobileLabelSystemPre> labelSystemPreList = mobileLabelSystemPreService.initMobileLabelSystemPre();
        Map<Integer, MobileLabelSystemPre> preInfoMap = labelSystemPreList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        //删除租户下布局内容
        RedisLock redisLock = new RedisLock("MobilePortalInfoContent:" + Utils.getTenantId());
        try {
            redisLock.lock();
            delMobilePortalContent(defPortalTent.getId(), null);
            //模版内容id和租户的内容id关系map，key：模版内容ID，val：租户内容ID
            Map<Long, Long> contentIdMap = new HashMap<>();
            for (MobilePortalInfoContent contentInfo : contentList) {
                MobilePortalInfoContent content = new MobilePortalInfoContent();
                BeanUtils.copyProperties(contentInfo, content);
                content.setId(null);
                content.setTenantId(Utils.getTenantId());
                content.setMobilePortalId(defPortalTent.getId());
                //如果是金刚球，需要获取金刚球的上级金刚区的ID
                if (contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                    Long parentId = contentIdMap.get(contentInfo.getParentId());
                    content.setParentId(parentId);
                }
                //除了金刚球，其他的获取预设组件ID
                if (!contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                    MobileLabelSystemPre systemPre = preInfoMap.get(contentInfo.getContentType());
                    content.setContentId(systemPre == null ? null : systemPre.getId());
                }
                mobilePortalInfoContentMapper.insert(content);
                if (!contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                    contentIdMap.put(contentInfo.getId(), content.getId());
                }
            }
        } catch (InterruptedException e) {
            log.error("initMobileDefPortal occur error:{}", e.getMessage());
        } finally {
            redisLock.unlock();
        }
        return defPortalTent;
    }


    /**
     * 删除布局内容
     *
     * @param portalId
     */
    public void delMobilePortalContent(Long portalId, List<Long> portalIdList) {
        QueryWrapper<MobilePortalInfoContent> condition = new QueryWrapper<>();
        if (null != portalId) {
            condition.eq("mobile_portal_id", portalId);
        }
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("mobile_portal_id", portalIdList);
        }
        mobilePortalInfoContentMapper.delete(condition);
    }


    /**
     * 增加用户使用移动门户的记录
     *
     * @param portId
     */
    public Boolean addUseRecord(Long portId) {
        //先删除最新的
        MobilePortalInfo mobilePortalInfo = mobilePortalInfoMapper.selectById(portId);
        if (ObjectUtils.isEmpty(mobilePortalInfo)) {
            return false;
        }
        QueryWrapper<MobilePortalInfoUse> condition = new QueryWrapper<>();
        condition.eq("create_user_id", Utils.getUserId());
        mobilePortalInfoUseMapper.delete(condition);
        //用户端查看门户详情，记录用户最近使用的门户
        MobilePortalInfoUse infoUse = new MobilePortalInfoUse();
        infoUse.setMobilePortalId(portId);
        infoUse.setTenantId(Utils.getTenantId());
        int insert = mobilePortalInfoUseMapper.insert(infoUse);
        return true;
    }


    @Override
    public List<MobilePortalInfo> checkPortal(MobilePortalInfo req) {
        QueryWrapper<MobilePortalInfo> condition = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(req.getName())) {
            condition.eq("name", req.getName());
        }
        if (null != req.getPortalType()) {
            condition.eq("portal_type", req.getPortalType());
        }
        if (null != req.getId()) {
            condition.ne("id", req.getId());
        }
        return mobilePortalInfoMapper.selectList(condition);
    }

    @Override
    @Transactional
    public MobilePortalInfo savePortal(MobilePortalInfo req) {

        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserName(Utils.getUserName());
        //设置租户ID
        req.setTenantId(Utils.getTenantId());
        //默认给未发布
        if (null == req.getStatus()) {
            req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            req.setCreateUserName(Utils.getUserName());
            req.setCreateTime(DateUtils.getNowTime(""));
            mobilePortalInfoMapper.insert(req);
            req.setId(req.getId());
        } else {
            mobilePortalInfoMapper.updateById(req);
        }
        //删除布局内容
        delMobilePortalContent(req.getId(), null);
        //保存涉及布局内容
        if (CollectionUtils.isNotEmpty(req.getContentList())) {
            savePortalContent(req);
        }
        return req;
    }

    @Override
    @Transactional
    public Integer copyPortal(MobilePortalInfo req) {
        //查询门户内容
        List<MobilePortalInfoContent> contentList = mobilePortalInfoContentMapper.queryMobiePortalCont(req.getId(), new ArrayList<>());
        //查询门户权限
        LambdaQueryWrapper<MobilePortalInfoAuth> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobilePortalInfoAuth::getMobilePortalId, req.getId());
        List<MobilePortalInfoAuth> mobilePortalAuthList = mobilePortalInfoAuthMapper.selectList(queryWrapper);
        //保存门户信息
        req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        req.setCreateUserName(Utils.getUserName());
        req.setCreateTime(DateUtils.getNowTime(""));
        req.setModifyUserName(Utils.getUserName());
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserId(Utils.getUserId());
        req.setId(null);
        String name = DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        req.setName(name + Constants.MOBILE_PORTAL_COPY_NAME);
        mobilePortalInfoMapper.insert(req);
        Long newPortalID = req.getId();
        //定义内容中的上下级
        Map<Long, Long> contentIdMap = new HashMap<>();
        //保存门户内容
        for (MobilePortalInfoContent content : contentList) {
            Long oldContentId = content.getId();
            content.setId(null);
            content.setMobilePortalId(newPortalID);
            content.setCreateTime(DateUtils.getNowTime(""));
            if (null != content.getParentId() && null != contentIdMap.get(content.getParentId())) {
                content.setParentId(contentIdMap.get(content.getParentId()));
            }
            mobilePortalInfoContentMapper.insert(content);
            contentIdMap.put(oldContentId, content.getId());
        }
        //保存门户权限内容
        for (MobilePortalInfoAuth mobilePortalAuth : mobilePortalAuthList) {
            mobilePortalAuth.setId(null);
            mobilePortalAuth.setMobilePortalId(newPortalID);
            mobilePortalAuth.setCreateTime(DateUtils.getNowTime(""));
            mobilePortalInfoAuthMapper.insert(mobilePortalAuth);
        }
        return null;
    }


    /**
     * 保存布局内容
     *
     * @param req
     */
    public void savePortalContent(MobilePortalInfo req) {
        if (null == req.getId()) {
            return;
        }
        for (MobilePortalInfoContent content : req.getContentList()) {
            //轮播图保存
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getCarouselInfo()));
            }
            //公告保存
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getNewsInfo()));
            }
            //标题组件保存
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getTitleInfo()));
            }
            // 分割线保存
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getDividerInfo()));
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getImageCompInfo()));
            }
            //业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getBusinessCompInfo()));
            }
            content.setMobilePortalId(req.getId());
            content.setTenantId(req.getTenantId());
            content.setParentId(0L);
            content.setId(null);
            mobilePortalInfoContentMapper.insert(content);
            if (CollectionUtils.isEmpty(content.getBallList())) {
                continue;
            }
            //插入精钢球信息
            for (MobilePortalInfoContent bill : content.getBallList()) {
                //金刚区ID
                Long id = content.getId();
                bill.setIsNameShow(content.getIsNameShow());
                bill.setParentId(id);
                bill.setId(null);
                bill.setMobilePortalId(content.getMobilePortalId());
                bill.setContentId(null);
                bill.setContentName(bill.getBallName());
                bill.setContentType(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal());
                bill.setCustomApplicationId(bill.getCustomApplicationId());
                mobilePortalInfoContentMapper.insert(bill);
            }
        }
    }


    @Override
    @Transactional
    public ResultPageBean pageQuery(PortalInfoQueryReq req) {
        //初始化通用门户
        initMobileDefPortal();
        //查询门户列表
        List<MobilePortalInfo> mobilePortalInfoList = getListMobilePortal(req);
        //组装缩略图地址
        for (MobilePortalInfo mobilePortalInfo : mobilePortalInfoList) {
            if (StringUtils.isNotEmpty(mobilePortalInfo.getPortalImgId())) {
                String portalImgUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + mobilePortalInfo.getPortalImgId();
                mobilePortalInfo.setPortalImgUrl(portalImgUrl);
            }
        }
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(mobilePortalInfoList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), mobilePortalInfoList.size())));
        return resultPageBean;
    }


    /**
     * 移动门户列表条件查询
     *
     * @param req
     * @return
     */
    @Override
    public List<MobilePortalInfo> getListMobilePortal(PortalInfoQueryReq req) {
        QueryWrapper<MobilePortalInfo> condition = new QueryWrapper<>();
        condition.eq("portal_type", req.getPortalType());
        if (StringUtils.isNotEmpty(req.getName())) {
            condition.like("name", req.getName());
        }
        if (null != req.getStatus()) {
            condition.eq("status", req.getStatus());
        }
        if (null == req.getSortType() || StringUtils.isEmpty(req.getOrderBy())) {
            condition.orderByDesc("default_flag").orderByDesc("modify_time");
        }
        if (null != req.getSortType() && req.getSortType().intValue() == 1) {
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                condition.orderByDesc("default_flag").orderByDesc("create_time");
            }
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                condition.orderByDesc("default_flag").orderByAsc("create_time");
            }
        }
        if (null != req.getSortType() && req.getSortType().intValue() == 2) {
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                condition.orderByDesc("default_flag").orderByDesc("modify_time");
            }
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                condition.orderByDesc("default_flag").orderByAsc("modify_time");
            }
        }
        // 兼容处理，pc端接口调用查询移动老门户列表时该字段有值，需要过滤掉默认门户
        if (ObjectUtils.isNotEmpty(req.getClientType())) {
            condition.ne("default_flag", Constants.DEFAULT_CONFIGURED_FLAG_YES);
        }
        return mobilePortalInfoMapper.selectList(condition);
    }


    @Override
    @Transactional
    public Integer updateBat(PortalInfoQueryReq req) {
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        //修改门户的状态
        mobilePortalInfoMapper.updateBat(req.getIdList(), req);
        return null;
    }

    @Override
    @Transactional
    public void saveApplicationColumn(ApplicationColumnReq applicationColumnReq) {
        LambdaQueryWrapper<MobileApplicatonColumn> wrapper = new LambdaQueryWrapper<>();
        Long parentId = applicationColumnReq.getId();
        MobileApplicatonColumn mobileApplicatonColumn = converter.convert(applicationColumnReq, MobileApplicatonColumn.class);
        mobileApplicatonColumn.setStatus(ObjectUtils.isEmpty(applicationColumnReq.getStatus()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getStatus());
        mobileApplicatonColumn.setIsNameShow(ObjectUtils.isEmpty(applicationColumnReq.getIsNameShow()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getIsNameShow());
        //新增栏目
        if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
            LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, Utils.getUserId()).isNull(MobileApplicatonColumn::getParentId);
            List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
            int count = CollectionUtils.isEmpty(mobileApplicatonColumns) ? 0 : mobileApplicatonColumns.size();
            mobileApplicatonColumn.setOrderId(count);
            applicatonColumnMapper.insert(mobileApplicatonColumn);
            parentId = mobileApplicatonColumn.getId();
        } else {
            applicatonColumnMapper.updateById(mobileApplicatonColumn);
            wrapper.eq(MobileApplicatonColumn::getParentId, parentId).eq(MobileApplicatonColumn::getCreateUserId, Utils.getUserId());
            applicatonColumnMapper.delete(wrapper);
        }
        wrapper.clear();
        //栏目中应用为空
        if (CollectionUtils.isEmpty(applicationColumnReq.getCustomApplication())) {
            return;
        }
        //自定义应用id
        List<Long> customApplicationIds = applicationColumnReq.getCustomApplication().stream()
                .map(SaveAppcationReq::getId).collect(Collectors.toList());

        // 只新增有权限的自定义应用
        List<Long> withPermissionList = mobileUserAuthService.validUserAppAuth(customApplicationIds);
        for (Long customApplicationId : customApplicationIds) {
            if (!withPermissionList.contains(customApplicationId)) {
                continue;
            }
            MobileApplicatonColumn mobileApplicatonColumnItem = new MobileApplicatonColumn();
            mobileApplicatonColumnItem.setParentId(parentId);
            mobileApplicatonColumnItem.setStatus(Constants.VALID_STATUS_ENABLE);
            mobileApplicatonColumnItem.setCustomApplicationId(customApplicationId);
            applicatonColumnMapper.insert(mobileApplicatonColumnItem);
        }
    }

    @Override
    @Transactional
    public void saveApplicationColumnNew(ApplicationColumnReqNew applicationColumnReq){
        LambdaQueryWrapper<MobileApplicatonColumnNew> wrapper = new LambdaQueryWrapper<>();
        Long parentId = applicationColumnReq.getId();
        //MobileApplicatonColumnNew mobileApplicatonColumnNew = converter.convert(applicationColumnReq, MobileApplicatonColumnNew.class);
        MobileApplicatonColumnNew mobileApplicatonColumnNew = new MobileApplicatonColumnNew();
        mobileApplicatonColumnNew.setId(applicationColumnReq.getId());
        mobileApplicatonColumnNew.setName(applicationColumnReq.getName());
        mobileApplicatonColumnNew.setStatus(applicationColumnReq.getStatus());
        mobileApplicatonColumnNew.setIsNameShow(applicationColumnReq.getIsNameShow());
        mobileApplicatonColumnNew.setParentId(applicationColumnReq.getParentId());
        mobileApplicatonColumnNew.setIsNameShow(ObjectUtils.isEmpty(applicationColumnReq.getIsNameShow()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getIsNameShow());
        //新增栏目
        if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
            LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, Utils.getUserId()).isNull(MobileApplicatonColumn::getParentId);
            List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
            int count = CollectionUtils.isEmpty(mobileApplicatonColumns) ? 0 : mobileApplicatonColumns.size();
            mobileApplicatonColumnNew.setOrderId(count);
            mobileApplicatonColumnNew.setStatus(ObjectUtils.isEmpty(applicationColumnReq.getStatus()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getStatus());
            mobileApplicatonColumnNewMapper.insert(mobileApplicatonColumnNew);
            parentId = mobileApplicatonColumnNew.getId();
        } else {
            mobileApplicatonColumnNewMapper.updateById(mobileApplicatonColumnNew);
            wrapper.eq(MobileApplicatonColumnNew::getParentId, parentId).eq(MobileApplicatonColumnNew::getCreateUserId, Utils.getUserId());
            mobileApplicatonColumnNewMapper.delete(wrapper);
        }
        wrapper.clear();
        //栏目中应用为空
        if (CollectionUtils.isEmpty(applicationColumnReq.getCustomApplication())) {
            return;
        }
        for (SaveAppcationReqNew saveAppcationReq : applicationColumnReq.getCustomApplication()) {
            MobileApplicatonColumnNew mobileApplicatonColumnItem = new MobileApplicatonColumnNew();
            mobileApplicatonColumnItem.setParentId(parentId);
            mobileApplicatonColumnItem.setStatus(Constants.VALID_STATUS_ENABLE);
            mobileApplicatonColumnItem.setCustomApplicationId(saveAppcationReq.getId());
            mobileApplicatonColumnItem.setSource(saveAppcationReq.getSource());
            mobileApplicatonColumnItem.setModuleId(saveAppcationReq.getModuleId());
            mobileApplicatonColumnNewMapper.insert(mobileApplicatonColumnItem);
        }
    }

    @Override
    @Transactional
    public Integer delBat(PortalInfoQueryReq req) {
        //删除门户
        mobilePortalInfoMapper.deleteBatchIds(req.getIdList());
        //删除门户内容
        delMobilePortalContent(null, req.getIdList());
        //删除组件权限
        delPortalAuth(req.getIdList());
        //删除预览数据
        QueryWrapper<MobilePortalPreview> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(req.getIdList())) {
            condition.in("mobile_portal_id", req.getIdList());
            mobilePortalPreviewMapper.delete(condition);
        }
        return null;
    }


    /**
     * 删除布局权限
     */
    public void delPortalAuth(List<Long> portalIdList) {
        QueryWrapper<MobilePortalInfoAuth> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("mobile_portal_id", portalIdList);
        }
        mobilePortalInfoAuthMapper.delete(condition);
    }

    @Override
    @Transactional
    public Integer savePortalAuth(PortalInfoAuthReq req) {
        //删除组件权限
        List<Long> portalIdList = new ArrayList<>();
        portalIdList.add(req.getId());
        delPortalAuth(portalIdList);
        //保存权限
        for (PortalInfoAuthReq.AuthVO authVO : req.getAuthList()) {
            MobilePortalInfoAuth portalInfoAuth = converter.convert(authVO, MobilePortalInfoAuth.class);
            portalInfoAuth.setMobilePortalId(req.getId());
            mobilePortalInfoAuthMapper.insert(portalInfoAuth);
        }
        return null;
    }

    /**
     * 查询布局权限
     */
    public List<MobilePortalInfoAuth> selectPortalAuth(List<Long> portalIdList) {
        QueryWrapper<MobilePortalInfoAuth> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("mobile_portal_id", portalIdList);
        }
        return mobilePortalInfoAuthMapper.selectList(condition);
    }


    @Override
    public MobilePortalInfoAuthResp selectByPortalAuth(Long portalId) {
        MobilePortalInfoAuthResp authResp = new MobilePortalInfoAuthResp();
        List<Long> portalIdList = new ArrayList<>();
        portalIdList.add(portalId);
        List<MobilePortalInfoAuth> authList = selectPortalAuth(portalIdList);
        if (CollectionUtils.isEmpty(authList)) {
            return authResp;
        }
        //组织
        List<MobilePortalInfoAuth> orgDataList = authList.stream().filter(item -> BizAuthTypeEnum.ORG.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgDataList)) {
            authResp.setOrgDataList(orgDataList);
        }
        //角色
        List<MobilePortalInfoAuth> roleDataList = authList.stream().filter(item -> BizAuthTypeEnum.ROLE.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(roleDataList)) {
            authResp.setRoleDataList(roleDataList);
        }
        //部门
        List<MobilePortalInfoAuth> deptDataList = authList.stream().filter(item -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deptDataList)) {
            authResp.setDeptDataList(deptDataList);
        }
        //用户
        List<MobilePortalInfoAuth> userDataList = authList.stream().filter(item -> BizAuthTypeEnum.USER.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userDataList)) {
            authResp.setUserDataList(userDataList);
        }
        return authResp;
    }

    @Override
    public MobilePortalInfoResp getMobilePortalDetail(MobilePortalInfo portalInfo) {
        MobilePortalInfoResp portalInfoResp = converter.convert(portalInfo, MobilePortalInfoResp.class);
        //查询移动门户内容信息
        List<MobilePortalInfoContent> portalInfoContentList = mobilePortalInfoContentMapper.queryMobiePortalCont(portalInfo.getId(), new ArrayList<>());
        if (CollectionUtils.isEmpty(portalInfoContentList)) {
            return portalInfoResp;
        }
        //金刚球内容
        List<MobilePortalInfoContent> billDataList = portalInfoContentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(item.getContentType())).collect(Collectors.toList());
        //金刚球按上级id做分组
        Map<Long, List<MobilePortalInfoContent>> billListMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(billDataList)) {
            billListMap = billDataList.stream().collect(Collectors.groupingBy(MobilePortalInfoContent::getParentId));
        }
        //非金刚球的内容
        List<MobilePortalInfoContent> preDataList = portalInfoContentList.stream().filter(item -> !Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preDataList)) {
            return portalInfoResp;
        }
        //查询移动预设组件
        List<Long> preIds = preDataList.stream().map(MobilePortalInfoContent::getContentId).collect(Collectors.toList());
        List<MobileLabelSystemPre> preList = mobileLabelSystemPreMapper.selectBatchIds(preIds);
        Map<Long, MobileLabelSystemPre> preInfoMap = preList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getId, Function.identity(), (a, b) -> a));

        List<MobilePortalInfoContentResp> contentList = new ArrayList<>();
        //返回预设组件名称并翻译
        for (MobilePortalInfoContent preData : preDataList) {
            MobilePortalInfoContentResp contentResp = converter.convert(preData, MobilePortalInfoContentResp.class);
            MobileLabelSystemPre labelSystemPre = preInfoMap.get(preData.getContentId());
            String contentNamePre = labelSystemPre == null ? preData.getContentName() : labelSystemPre.getName();
            String contentName = translateService.translateTextCache(contentNamePre, StringUtils.EMPTY);
            preData.setContentName(contentName);

            //金刚区，组装金刚球信息
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(preData.getContentType())) {
                List<MobilePortalInfoContent> billList = billListMap.get(preData.getId());
                List<BallResp> ballList = new ArrayList<>();
                if (CollectionUtils.isEmpty(billList)) {
                    contentResp.setBallList(ballList);
                    contentList.add(contentResp);
                    continue;
                }
                for (MobilePortalInfoContent bill : billList) {
                    bill.setBallName(bill.getContentName());
                    BallResp ballResp = converter.convert(bill, BallResp.class);
                    if (StringUtils.isNotBlank(bill.getContentIcon()) && ObjectUtils.isNotEmpty(bill.getIconType())) {
                        if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            ballResp.setIconUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + bill.getContentIcon());
                        } else if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            ballResp.setIconUrl(envProperties.getSemcWebUrl() + bill.getContentIcon());
                        }
                    }
                    ballList.add(ballResp);
                }
                contentResp.setBallList(ballList);
            }
            //组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(preData.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalContentCarousel.class);
                contentResp.setCarouselInfo(carouselInfo);
            }
            //组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(preData.getContentType())) {
                MobilePortalContentNews newsInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalContentNews.class);
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(0);
                }
                contentResp.setNewsInfo(newsInfo);
            }
            //组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(preData.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                //如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + iconUrl;
                }
                //如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                contentResp.setTitleInfo(titleInfo);
            }
            //组装分割线
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(preData.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                contentResp.setDividerInfo(dividerInfo);
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(preData.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + imageCompInfo.getImageId());
                }
                contentResp.setImageCompInfo(imageCompInfo);
            }
            //业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(preData.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(preData.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        String imageUrl = StringUtils.isEmpty(image.getImageId()) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + image.getImageId();
                        image.setImageUrl(imageUrl);
                    }
                }
                contentResp.setBusinessCompInfo(businessCompInfo);
            }
            contentList.add(contentResp);
        }
        portalInfoResp.setContentList(contentList);
        return portalInfoResp;
    }

    @Override
    public MobilePortalPreview previewPortal(MobilePortalInfo req, PortalInfo portalInfo) {
        if (ObjectUtils.isNotEmpty(portalInfo)) {
            return saveNewPreview(portalInfo);
        } else {
            MobilePortalInfoResp portalInfoResp = new MobilePortalInfoResp();
            //列表页面的预览
            if (req.getId() != null) {
                //查询门户内容
                portalInfoResp = getMobilePortalDetail(req);
            }
            //保存预览数据
            return savePreviewPrtal(req, portalInfoResp);
        }
    }

    @Override
    public MobilePortalPreview getPreviewPortal(Long id){
        return InterceptorIgnoreUtil.handler(() -> mobilePortalPreviewMapper.selectById(id));
    }

    @Override
    public MobilePortalInfoResp getPreMobilePortal(Long id) {
        MobilePortalInfoResp result = new MobilePortalInfoResp();
        MobilePortalPreview mobilePortalPreview = mobilePortalPreviewMapper.selectById(id);
        if (mobilePortalPreview == null) {
            String recentlyMsg = messageUtils.getMessage("error.message.not.auth");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        if (null != mobilePortalPreview.getEndTime() && mobilePortalPreview.getEndTime().before(new Date())) {
            String recentlyMsg = messageUtils.getMessage("error.message.choose.qr.code.invalid");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        String portalContentListJson = mobilePortalPreview.getPortalContentList();
        List<MobilePortalInfoContentResp> mobilePortalInfoContentResps = JsonUtils.jsonToObject(portalContentListJson, new TypeReference<List<MobilePortalInfoContentResp>>() {
        });
        converter.convert(mobilePortalPreview, result);

        if (CollectionUtils.isEmpty(mobilePortalInfoContentResps)) {
            return result;
        }
        for (MobilePortalInfoContentResp mobilePortalInfoContent : mobilePortalInfoContentResps) {
            //如果是金刚区则添加相关的金刚球
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(mobilePortalInfoContent.getContentType())) {
                // 新旧结构兼容
                List<BallResp> ballList = this.getBallList(mobilePortalInfoContent);
                List<BallResp> ballAuthResp = filterPermissionBallList(ballList);
                ballAuthResp.forEach(item -> {
                    item.setContentIcon(StringUtils.isNotBlank(item.getContentIcon()) ? item.getContentIcon() : Constants.CONTENT_ICON_DEF);
                    if (ObjectUtils.isNotEmpty(item.getIconType())) {
                        if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            item.setIconUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + item.getContentIcon());
                        } else if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            item.setIconUrl(envProperties.getSemcWebUrl() + item.getContentIcon());
                        }
                    }
                });
                mobilePortalInfoContent.setBallList(ballAuthResp);
            }
            //组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalContentNews newsInfo = mobilePortalInfoContent.getNewsInfo();
                if (null != newsInfo) {
                    if (newsInfo.getNewsLikeCountFlag() == null) {
                        newsInfo.setNewsLikeCountFlag(0);
                    }
                    //如果选择的是二级，是以逗号分隔，则取第一个值作为一级公告类型ID，第二个值作为二级公告类型ID
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",")) {
                        String[] newsTypeIds = newsInfo.getNewsTypeIdStr().split(",");
                        if (newsTypeIds.length >= 2) {
                            newsInfo.setChildrenNewsTypeId(Integer.parseInt(newsTypeIds[1]));
                            newsInfo.setNewsTypeId(Integer.parseInt(newsTypeIds[0]));
                        }
                    }
                    //只有一级
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                        newsInfo.setNewsTypeId(Integer.parseInt(newsInfo.getNewsTypeIdStr()));
                    }
                    mobilePortalInfoContent.setNewsInfo(newsInfo);
                }
            }
            //组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalContentCarousel carouselInfo = mobilePortalInfoContent.getCarouselInfo();
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    String icon = image.getContentIcon();
                    //处理图标-图标库
                    if (null != image.getImgType()
                            && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                            && StringUtils.isNotEmpty(icon)
                    ) {
                        icon = envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                mobilePortalInfoContent.setCarouselInfo(carouselInfo);
            }
            //组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = mobilePortalInfoContent.getTitleInfo();
                //如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType()
                        && StringUtils.isNotEmpty(iconUrl)
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    iconUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + iconUrl;
                }
                //如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && StringUtils.isNotEmpty(iconUrl)
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                mobilePortalInfoContent.setTitleInfo(titleInfo);
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = mobilePortalInfoContent.getImageCompInfo();
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + imageCompInfo.getImageId());
                }
                mobilePortalInfoContent.setImageCompInfo(imageCompInfo);
            }
            //业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = mobilePortalInfoContent.getBusinessCompInfo();
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        String imageUrl = StringUtils.isEmpty(image.getImageId()) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + image.getImageId();
                        image.setImageUrl(imageUrl);
                    }
                }
                mobilePortalInfoContent.setBusinessCompInfo(businessCompInfo);
            }
        }
        result.setContentList(mobilePortalInfoContentResps);
        return result;
    }

    private List<BallResp> getBallList(MobilePortalInfoContentResp mobilePortalInfoContent) {
        List<BallResp> ballList = mobilePortalInfoContent.getBallList();
        if (CollectionUtils.isNotEmpty(ballList)) {
            return ballList;
        }
        String contentAttr = mobilePortalInfoContent.getContentAttr();
        if (StringUtils.isBlank(contentAttr)) {
            return ballList;
        }
        PortalContentKingKongDistrict district = JSON.parseObject(contentAttr, PortalContentKingKongDistrict.class);
        if (null == district) {
            return ballList;
        }
        mobilePortalInfoContent.setIsNameShow(district.getIsNameShow());
        mobilePortalInfoContent.setInteractionType(district.getInteractionType());
        mobilePortalInfoContent.setCustomType(district.getCustomType());
        mobilePortalInfoContent.setColumnNum(district.getColumnNum());
        mobilePortalInfoContent.setLineNum(district.getLineNum());
        List<PortalContentKingKongDistrictBall> districtBallList = district.getBallList();
        if (CollectionUtils.isEmpty(districtBallList)) {
            return ballList;
        }
        ballList = districtBallList.stream().map(ball -> {
            return BallResp.builder()
                    .ballName(ball.getBallName())
                    .iconType(ball.getIconType())
                    .contentIcon(ball.getContentIcon())
                    .iconUrl(ball.getIconUrl())
                    .jumpType(ball.getJumpType())
                    .jumpTarget(ball.getJumpTarget())
                    .customApplicationId(ball.getCustomApplicationId())
                    .build();
        }).collect(Collectors.toList());
        mobilePortalInfoContent.setBallList(ballList);
        return ballList;
    }

    @Override
    public Boolean saveMobilePortalTypeUse(MobilePortalTypeUse typeUse) {
        //删除最初的
        LambdaQueryWrapper<MobilePortalTypeUse> deleteWrapper = new LambdaQueryWrapper<>();
        deleteWrapper.eq(MobilePortalTypeUse::getCreateUserId, Utils.getUserId());
        mobilePortalTypeUserMapper.delete(deleteWrapper);
        mobilePortalTypeUserMapper.insert(typeUse);

        if (!ObjectUtils.isEmpty(typeUse.getMobilePortalId())) {
            MobilePortalInfoUse mobilePortalInfoUse = new MobilePortalInfoUse();
            mobilePortalInfoUse.setMobilePortalId(typeUse.getMobilePortalId());
            MobilePortalInfo mobilePortalInfo = mobilePortalInfoMapper.selectById(typeUse.getMobilePortalId());
            if (ObjectUtils.isNotEmpty(mobilePortalInfo)) {
                mobilePortalInfoUse.setName(mobilePortalInfo.getName());
            }
            LambdaQueryWrapper<MobilePortalInfoUse> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(MobilePortalInfoUse::getCreateUserId, Utils.getUserId());
            mobilePortalInfoUseMapper.delete(wrapper);
            mobilePortalInfoUseMapper.insert(mobilePortalInfoUse);
        }
        return true;
    }

    @Override
    public ResponseEntity<?> checkPortalInfo(MobilePortalInfo portalInfo) {
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(false);
        QueryWrapper<MobilePortalInfoAuth> condition = new QueryWrapper<>();
        //获取登录用户权限内门户
        List<MobilePortalInfoAuth> portalInfoAuthList = mobilePortalInfoAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(condition));
        List<Long> portalIds = portalInfoAuthList.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
        //判断门户是否在权限内
        if (portalIds.contains(portalInfo.getId())) {
            checkResp.setIsHavePort(true);
        } else {
            String msg = messageUtils.getMessage(I18NKey.PORTAL_NOT_AUTH);
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                msg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
            }
            checkResp.setErrorMsg(msg);
        }
        return ResponseEntityWrapper.wrapperOk(checkResp);
    }


    /**
     * 保存预览数据
     *
     * @param req
     * @return
     */
    public MobilePortalPreview savePreviewPrtal(MobilePortalInfo req, MobilePortalInfoResp portalInfoResp) {
        MobilePortalPreview portalPreview = new MobilePortalPreview();
        String contentListJson = "";
        if (req.getId() != null) {
            converter.convert(portalInfoResp, portalPreview);
            contentListJson = JSON.toJSONString(portalInfoResp.getContentList());
            portalPreview.setMobilePortalId(req.getId());
        } else {
            converter.convert(req, portalPreview);
            contentListJson = JSON.toJSONString(req.getContentList());
        }
        List<MobilePortalInfoContent> mobilePortalInfoContentResps = JsonUtils.jsonToObject(contentListJson, new TypeReference<List<MobilePortalInfoContent>>() {
        });
        portalPreview.setContentList(mobilePortalInfoContentResps);
        portalPreview.setPortalContentList(contentListJson);
        //二维码2小时有效
        Date endDate = DateUtils.getNewDate(new Date(), 0, 0, 0, 2);
        portalPreview.setEndTime(endDate);
        portalPreview.setId(null);
        if (ObjectUtils.isNotEmpty(req.getOldPortalFlag()) && Boolean.FALSE.equals(req.getOldPortalFlag())) {
            portalPreview.setVersionDefault(1);
        }else{
            portalPreview.setVersionDefault(0);
        }
        mobilePortalPreviewMapper.insert(portalPreview);
        return portalPreview;
    }

    /**
     * 保存新门户的预览数据
     *
     * @return 返回
     */
    public MobilePortalPreview saveNewPreview(PortalInfo portalInfo) {
        MobilePortalPreview portalPreview = new MobilePortalPreview();
        portalPreview.setDefaultFlag(portalInfo.getDefaultFlag());
        portalPreview.setMobilePortalId(portalInfo.getId());
        portalPreview.setPortalTypeSource(portalInfo.getPortalTypeSource());
        portalPreview.setName(portalInfo.getName());
        portalPreview.setTitle(portalInfo.getTitle());
        portalPreview.setBgColor(portalInfo.getBgColor());
        portalPreview.setPortalType(portalInfo.getPortalType());
        portalPreview.setPortalDesc(portalInfo.getPortalDesc());
        portalPreview.setPortalImgId(portalInfo.getPortalImgId());
        portalPreview.setTenantId(portalInfo.getTenantId());
        portalPreview.setCreateUserName(portalInfo.getCreateUserName());
        portalPreview.setModifyUserName(portalInfo.getModifyUserName());
        String contentListJson = JSON.toJSONString(portalInfo.getContentList());

        List<MobilePortalInfoContent> mobilePortalInfoContentResps = JsonUtils.jsonToObject(contentListJson, new TypeReference<List<MobilePortalInfoContent>>() {});
        portalPreview.setContentList(mobilePortalInfoContentResps);
        portalPreview.setPortalContentList(contentListJson);
        //二维码2小时有效
        Date endDate = DateUtils.getNewDate(new Date(), 0, 0, 0, 2);
        portalPreview.setEndTime(endDate);
        portalPreview.setId(null);
        portalPreview.setVersionDefault(portalInfo.getVersionDefault());
        mobilePortalPreviewMapper.insert(portalPreview);
        return portalPreview;
    }


    @Override
    public List<MobileAppColumnResp> getApplicationColumnList() {
        String userId = Utils.getUserId();
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, userId).isNull(MobileApplicatonColumn::getCustomApplicationId)
                .isNull(MobileApplicatonColumn::getParentId).orderByAsc(MobileApplicatonColumn::getOrderId);
        List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
        List<MobileAppColumnResp> result = mobileApplicatonColumns.stream().map(item -> {
            MobileAppColumnResp mobileAppColumnResp = converter.convert(item, MobileAppColumnResp.class);
            return mobileAppColumnResp;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<MobileAppColumnResp> getApplicationColumnListNew() {
        String userId = Utils.getUserId();
        LambdaQueryWrapper<MobileApplicatonColumnNew> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumnNew::getCreateUserId, userId).isNull(MobileApplicatonColumnNew::getCustomApplicationId)
                .isNull(MobileApplicatonColumnNew::getParentId).orderByAsc(MobileApplicatonColumnNew::getOrderId);
        List<MobileApplicatonColumnNew> mobileApplicatonColumns = mobileApplicatonColumnNewMapper.selectList(queryWrapper);
        List<MobileAppColumnResp> result = mobileApplicatonColumns.stream().map(item -> {
            //MobileAppColumnResp mobileAppColumnResp = converter.convert(item, MobileAppColumnResp.class);
            MobileAppColumnResp mobileAppColumnResp = new MobileAppColumnResp();
            mobileAppColumnResp.setId(item.getId());
            mobileAppColumnResp.setCustomApplicationId(item.getCustomApplicationId());
            mobileAppColumnResp.setIsNameShow(item.getIsNameShow());
            mobileAppColumnResp.setName(item.getName());
            mobileAppColumnResp.setOrderId(item.getOrderId());
            mobileAppColumnResp.setParentId(item.getParentId());
            mobileAppColumnResp.setStatus(item.getStatus());
            mobileAppColumnResp.setTenantId(item.getTenantId());
            return mobileAppColumnResp;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public MobileAppColumnResp getApplicationColumnDetailNew(MobileApplicatonColumnNew mobileApplicatonColumn) {
        Long parentId = mobileApplicatonColumn.getId();
        LambdaQueryWrapper<MobileApplicatonColumnNew> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumnNew::getParentId, parentId).eq(MobileApplicatonColumnNew::getCreateUserId, Utils.getUserId());
        //栏目下所属的自定义应用
        queryWrapper.orderByAsc(MobileApplicatonColumnNew::getId);
        List<MobileApplicatonColumnNew> mobileApplicatonColumns = mobileApplicatonColumnNewMapper.selectList(queryWrapper);
        //自定义id
        List<String> customAppIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumnNew::getCustomApplicationId).collect(Collectors.toList());
        //MobileAppColumnResp mobileAppColumnResp = converter.convert(mobileApplicatonColumn, MobileAppColumnResp.class);
        MobileAppColumnResp mobileAppColumnResp = new MobileAppColumnResp();
        mobileAppColumnResp.setId(mobileApplicatonColumn.getId());
        mobileAppColumnResp.setCustomApplicationId(mobileApplicatonColumn.getCustomApplicationId());
        mobileAppColumnResp.setIsNameShow(mobileApplicatonColumn.getIsNameShow());
        mobileAppColumnResp.setName(mobileApplicatonColumn.getName());
        mobileAppColumnResp.setOrderId(mobileApplicatonColumn.getOrderId());
        mobileAppColumnResp.setParentId(mobileApplicatonColumn.getParentId());
        mobileAppColumnResp.setStatus(mobileApplicatonColumn.getStatus());
        mobileAppColumnResp.setTenantId(mobileApplicatonColumn.getTenantId());
        List<MobileDatasourceInfoVO> customApps = new ArrayList<>();
        /*if (CollectionUtils.isNotEmpty(customAppIds)) {
            customApps = getCustomApplicationNew(customAppIds);
        }*/
        mobileAppColumnResp.setMobileCustomAppList(customApps);
        return mobileAppColumnResp;
    }

    @Override
    public MobileAppColumnResp getApplicationColumnDetail(MobileApplicatonColumn mobileApplicatonColumn) {
        Long parentId = mobileApplicatonColumn.getId();
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumn::getParentId, parentId).eq(MobileApplicatonColumn::getCreateUserId, Utils.getUserId());
        //栏目下所属的自定义应用
        queryWrapper.orderByAsc(MobileApplicatonColumn::getId);
        List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
        //自定义id
        List<Long> customAppIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        MobileAppColumnResp mobileAppColumnResp = converter.convert(mobileApplicatonColumn, MobileAppColumnResp.class);
        List<MobileDatasourceInfoVO> customApps = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            customApps = getCustomApplication(customAppIds);
        }
        mobileAppColumnResp.setMobileCustomAppList(customApps);
        return mobileAppColumnResp;
    }

    /**
     * 根据自定义id获取自定义应用
     *
     * @param customAppIds
     * @return
     */
    @Override
    public List<MobileDatasourceInfoVO> getCustomApplication(List<Long> customAppIds) {
        List<MobileDatasourceInfoVO> result = new ArrayList<>();
        // 查询移动数据源配置
        List<MobileDatasourceInfo> mobileDatasourceInfos = mobileCustomApplicationMapper.selectMobileList(customAppIds);
        if (CollectionUtils.isEmpty(mobileDatasourceInfos)) {
            return result;
        }
        List<MobileDatasourceClassification> classificationList = mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        Map<Long, String> idNameMap = classificationList.stream().collect(Collectors.toMap(MobileDatasourceClassification::getId, MobileDatasourceClassification::getClassificationName, (a, b) -> a));

        // 过滤出用户有权限的自定义应用列表，不是鼎捷非雅典娜应用，不参与校验
        List<Long> mobileAppIdList = mobileDatasourceInfos.stream()
                .filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());

        // 鼎捷非雅典娜应用，校验权限，返回有权限的自定义应用id
        List<MobileDatasourceInfo> notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List<Long> withPermissionList = mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }

        // 构建返回列表
        for (MobileDatasourceInfo mobileDatasourceInfo : mobileDatasourceInfos) {
            MobileDatasourceInfoVO mobileCustomApplicationVO = converter.convert(mobileDatasourceInfo, MobileDatasourceInfoVO.class);
            if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) {
                mobileCustomApplicationVO.setAuthFlag(false);
            }

            // 分类名称
            if (MapUtils.isNotEmpty(idNameMap)) {
                mobileCustomApplicationVO.setClassificationName(idNameMap.get(mobileDatasourceInfo.getClassificationId()));
            }
            String icon = mobileDatasourceInfo.getIcon();
            //处理图标-图标库
            if (null != mobileDatasourceInfo.getIconType()
                    && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                icon = envProperties.getSemcWebUrl() + icon;
            }
            //处理图标-自定义
            if (null != mobileDatasourceInfo.getIconType()
                    && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                icon = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + icon;
            }
            mobileCustomApplicationVO.setIcon(icon);
            result.add(mobileCustomApplicationVO);
        }
        return result;
    }

    /**
     * 根据自定义id获取自定义应用  默认门户
     *
     * @param customAppIds
     * @return
     */
    @Override
    public List<MobileDatasourceInfoVO> getCustomApplicationNew(List<String> customAppIds) {
        if (CollectionUtils.isNotEmpty(customAppIds)){

        }
        List<MobileDatasourceInfoVO> result = new ArrayList<>();

        // 查询移动数据源配置
        List<Long> idList = new ArrayList<>();
        for (String id : customAppIds){
            Long aLong = Long.valueOf(id);
            idList.add(aLong);
        }
        List<MobileDatasourceInfo> mobileDatasourceInfos = mobileCustomApplicationMapper.selectMobileList(idList);
        if (CollectionUtils.isEmpty(mobileDatasourceInfos)) {
            return result;
        }
        List<MobileDatasourceClassification> classificationList = mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        Map<Long, String> idNameMap = classificationList.stream().collect(Collectors.toMap(MobileDatasourceClassification::getId, MobileDatasourceClassification::getClassificationName, (a, b) -> a));

        // 过滤出用户有权限的自定义应用列表，不是鼎捷非雅典娜应用，不参与校验
        List<Long> mobileAppIdList = mobileDatasourceInfos.stream()
                .filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());

        // 鼎捷非雅典娜应用，校验权限，返回有权限的自定义应用id
        List<MobileDatasourceInfo> notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List<Long> withPermissionList = mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }

        // 构建返回列表
        for (MobileDatasourceInfo mobileDatasourceInfo : mobileDatasourceInfos) {
            MobileDatasourceInfoVO mobileCustomApplicationVO = converter.convert(mobileDatasourceInfo, MobileDatasourceInfoVO.class);
            if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) {
                mobileCustomApplicationVO.setAuthFlag(false);
            }

            // 分类名称
            if (MapUtils.isNotEmpty(idNameMap)) {
                mobileCustomApplicationVO.setClassificationName(idNameMap.get(mobileDatasourceInfo.getClassificationId()));
            }
            String icon = mobileDatasourceInfo.getIcon();
            //处理图标-图标库
            if (null != mobileDatasourceInfo.getIconType()
                    && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                icon = envProperties.getSemcWebUrl() + icon;
            }
            //处理图标-自定义
            if (null != mobileDatasourceInfo.getIconType()
                    && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                icon = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + icon;
            }
            mobileCustomApplicationVO.setIcon(icon);
            result.add(mobileCustomApplicationVO);
        }
        return result;
    }


    /**
     * 拼接作业属性
     *
     * @param appLinkDTO 应用
     * @param workCode   源数据
     * @return 返回对象
     */
    private String appendJobField(AppLinkDTO appLinkDTO, String workCode) {
        String cloudwebsite = appLinkDTO.getCloudwebsite();
        // 查询km应用作业池
        List<AppJobDTO> appJobDTOList = kmService.queryAppJobList();
        if (CollectionUtils.isEmpty(appJobDTOList)) {
            return cloudwebsite;
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> appLinkDTO.getId().equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return cloudwebsite;
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> workCode.equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return cloudwebsite;
        }
        //获取作业跳转路径映射类型
        String jobType = getJobTypeMap(job.getType());
        cloudwebsite = cloudwebsite + "&routerLink=/" + jobType + "&code=" + job.getCode() + "&name=" + job.getName() + "&type=" + job.getType()
                + "&category=" + job.getCategory() + "&ifCustom=" + job.getIfCustom();
        return cloudwebsite;
    }

    /**
     * 获取作业跳转路径映射map
     *
     * @return
     */
    public String getJobTypeMap(String type) {
        Map<String, String> jobTypeMap = new HashMap<>();
        //基础资料/公共作业
        jobTypeMap.put("baseDataEntry".toLowerCase(), "base-data-entry");
        jobTypeMap.put("statement".toLowerCase(), "report");
        jobTypeMap.put("manualStartProject".toLowerCase(), "add-task");
        return jobTypeMap.get(type.toLowerCase());
    }

    /**
     * 拼接作业地址
     *
     * @param jobUrl
     * @return
     */
    public String packageJobUrl(String jobUrl) {
        if (StringUtils.isEmpty(jobUrl)) {
            return "?";
        }
        if (jobUrl.contains("?")) {
            return jobUrl;
        } else {
            return "?" + jobUrl;
        }
    }

    @Override
    @Transactional
    public void setColumnOrder(List<Long> columIds) {
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, Utils.getUserId())
                .in(MobileApplicatonColumn::getId, columIds);
        List<MobileApplicatonColumn> columns = applicatonColumnMapper.selectList(queryWrapper);
        //自定义栏目
        Map<Long, MobileApplicatonColumn> idMap = columns.stream().collect(Collectors.toMap(MobileApplicatonColumn::getId, Function.identity()));
        Integer counnt = 0;
        for (Long columId : columIds) {
            MobileApplicatonColumn mobileApplicatonColumn = idMap.get(columId);
            mobileApplicatonColumn.setOrderId(counnt);
            applicatonColumnMapper.updateById(mobileApplicatonColumn);
            counnt++;
        }
    }

    @Override
    @Transactional
    public void setColumnOrderNew(List<Long> columIds) {
        LambdaQueryWrapper<MobileApplicatonColumnNew> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumnNew::getCreateUserId, Utils.getUserId())
                .in(MobileApplicatonColumnNew::getId, columIds);
        List<MobileApplicatonColumnNew> columns = mobileApplicatonColumnNewMapper.selectList(queryWrapper);
        //自定义栏目
        Map<Long, MobileApplicatonColumnNew> idMap = columns.stream().collect(Collectors.toMap(MobileApplicatonColumnNew::getId, Function.identity()));
        Integer counnt = 0;
        for (Long columId : columIds) {
            MobileApplicatonColumnNew mobileApplicatonColumn = idMap.get(columId);
            mobileApplicatonColumn.setOrderId(counnt);
            mobileApplicatonColumnNewMapper.updateById(mobileApplicatonColumn);
            counnt++;
        }
    }

    @Override
    @Transactional
    public void delColumn(List<Long> columnIds) {
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(MobileApplicatonColumn::getParentId, columnIds);
        //删除栏目下的应用
        applicatonColumnMapper.delete(queryWrapper);
        //删除栏目
        applicatonColumnMapper.deleteBatchIds(columnIds);
    }

    @Override
    @Transactional
    public void delColumnNew(List<Long> columnIds) {
        LambdaQueryWrapper<MobileApplicatonColumnNew> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(MobileApplicatonColumnNew::getParentId, columnIds);
        //删除栏目下的应用
        mobileApplicatonColumnNewMapper.delete(queryWrapper);
        //删除栏目
        mobileApplicatonColumnNewMapper.deleteBatchIds(columnIds);
    }

    @Override
    public FullBackResp getFullCallBackUrl(MobileSSOReq mobileSSOReq) {
        // 查询移动数据源配置
        Integer customApplicationId = Integer.valueOf(mobileSSOReq.getCustomApplicationId());
        LambdaQueryWrapper<MobileDatasourceInfo> mobileDatasourceInfoLambdaQueryWrapper = new LambdaQueryWrapper<>();
        mobileDatasourceInfoLambdaQueryWrapper.eq(MobileDatasourceInfo::getId, customApplicationId);
        MobileDatasourceInfo mobileDatasourceInfo = mobileCustomApplicationMapper.selectOne(mobileDatasourceInfoLambdaQueryWrapper);

        // 构建返回链接
        FullBackResp mobileFullBack = getMobileFullBack(mobileDatasourceInfo);
        if (ObjectUtils.isEmpty(mobileFullBack)) {
            return null;
        }
        return mobileFullBack;
    }


    /**
     * 组装移动端应用作业跳转地址
     *
     * @param mobileDatasourceInfo 移动端应用作业信息
     * @return
     */
    public FullBackResp getMobileFullBack(MobileDatasourceInfo mobileDatasourceInfo) {
        FullBackResp fullBackResp = new FullBackResp();
        String mobileLinkUrl = "";
        boolean isNeedCode = false;
        // 配置的是三方应用/作业
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.MOBILE_THIRD_APPLICATION.getValue())) {
            // 查询应用配置信息
            List<MobileSsoInfo> mobileSsoInfoList = mobileSsoInfoService.queryMobileLinkSsoList(Long.valueOf(mobileDatasourceInfo.getApplicationPrimaryId()));
            if (CollectionUtils.isEmpty(mobileSsoInfoList)) {
                return fullBackResp;
            }
            MobileSsoInfo mobileSsoInfo = mobileSsoInfoList.get(0);
            // 自定义作业方式
            String mobileJobUrl = "";
            if (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(mobileDatasourceInfo.getIsJob())) {
                mobileJobUrl = mobileDatasourceInfo.getCallBackUrl();
            }
            // 作业编码不为空
            else if (StringUtils.isNotEmpty(mobileDatasourceInfo.getWorkCode())) {
                mobileJobUrl = getMobileJobUrl(mobileSsoInfo.getAppId(), mobileDatasourceInfo.getWorkCode());
            }
            mobileLinkUrl = mobileSsoInfo.getMobileLinkUrl();
            // 如果是作业集成
            if (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(mobileDatasourceInfo.getIsJob()) || StringUtils.isNotEmpty(mobileDatasourceInfo.getWorkCode())) {
                String[] linkParamArray = mobileSsoInfo.getMobileLinkUrl().split("\\?");
                mobileLinkUrl = linkParamArray[0] + packageJobUrl(mobileJobUrl) + "&" + linkParamArray[1];
            }
            fullBackResp.setAppId(mobileSsoInfo.getAppId());
            fullBackResp.setRegisterUrl(mobileSsoInfo.getCallBackUrl());
            isNeedCode = true;
        }
        // 3-鼎捷雅典娜应用
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.DIGIWIN_ATHENA_APPLICATION.getValue())) {
            List<TenantAppDTO> tenantAppList = iamService.queryTenantApps();
            String applicationPrimaryId = mobileDatasourceInfo.getApplicationPrimaryId();
            List<TenantAppDTO> list = tenantAppList.stream().filter(item -> applicationPrimaryId.equals(item.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return fullBackResp;
            }
            TenantAppDTO tenantAppDTO = list.get(0);
            String callBackUrl = tenantAppDTO.getCloudwebsite() + "/sso-login?userToken=" + AppAuthContextHolder.getContext().getAuthoredUser().getToken();
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setId(tenantAppDTO.getId());
            appLinkDTO.setCloudwebsite(callBackUrl);
            mobileLinkUrl = appendJobField(appLinkDTO, mobileDatasourceInfo.getWorkCode());
        }
        // 2-鼎捷非雅典娜应用
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue())) {
            //校验用户是否有该移动应用作业权限
            List<Long> withPermissionList = mobileUserAuthService.validPermission(Collections.singletonList(mobileDatasourceInfo));
            if (CollectionUtils.isNotEmpty(withPermissionList)) {
                mobileLinkUrl = packageMobileCloudWebsite(mobileDatasourceInfo);
                fullBackResp.setIsHavePerm(true);
            }
        }
        fullBackResp.setMobileCloudWebsite(mobileLinkUrl);
        fullBackResp.setIsNeedCode(isNeedCode);
        return fullBackResp;
    }

    /**
     * 校验用户是否有该移动应用作业权限
     *
     * @param mobileDatasourceInfo 移动端应用作业信息
     * @return
     */
    public String packageMobileCloudWebsite(MobileDatasourceInfo mobileDatasourceInfo) {
        String mobileCloudWebsite = "";
        //其他类型的，替换枚举值
        if (null == mobileDatasourceInfo.getSpecialSign()) {
            mobileCloudWebsite = packageMobileOtherUrl(mobileDatasourceInfo.getApplicationConfig());
            return mobileCloudWebsite;
        }
        //绿色智机
        if (mobileDatasourceInfo.getSpecialSign().equals(Constants.SpecialSignEnum.TOPIC_PRESET.getFlag())) {
            mobileCloudWebsite = topicPresetService.getTopicPresetUrl(mobileDatasourceInfo.getApplicationConfig());
        }
        //每刻
        if (mobileDatasourceInfo.getSpecialSign().equals(Constants.SpecialSignEnum.MAYCUR.getFlag())) {
            //获取工号
            String userId = eocService.getEmpJobNum();
            //没有工号
            if (StringUtils.isEmpty(userId)) {
                return mobileDatasourceInfo.getApplicationConfig();
            }
            long timestamp = System.currentTimeMillis();
            //获取ssoToken
            String ssoToken = mayCurService.getSsoToken(userId, envProperties.getMayCurSecret(), timestamp);
            mobileCloudWebsite = mayCurService.getHomeSsoUrl(mobileDatasourceInfo.getApplicationConfig(), envProperties.getMayCurEntCode(), userId, ssoToken, timestamp);
        }
        return mobileCloudWebsite;
    }

    /**
     * 组装跳转地址
     *
     * @param url
     * @return
     */
    public String packageMobileOtherUrl(String url) {
        String locale = LocaleContextHolder.getLocale().toString();
        //替换${iamUserId}
        if (url.contains(TWAppUrlVariableEnum.IAM_USER_ID.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.IAM_USER_ID.getVariableName(), Utils.getUserId());
        }
        //替换${mobile_token}
        if (url.contains(TWAppUrlVariableEnum.MOBILE_TOKEN.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.MOBILE_TOKEN.getVariableName(), Utils.getUserToken());
        }
        //替换${companyID}
        if (url.contains(TWAppUrlVariableEnum.COMPANY_ID.getVariableName())) {
            // url=url.replace(TWAppUrlVariableEnum.COMPANY_ID.getVariableName(),Utils.getUserToken());
        }
        //替换${locale}
        if (url.contains(TWAppUrlVariableEnum.LOCALE.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.LOCALE.getVariableName(), locale);
        }
        //替换${robamAppUid}
        if (url.contains(TWAppUrlVariableEnum.PERSON_ID.getVariableName())) {
            //  url=url.replace(TWAppUrlVariableEnum.PERSON_ID.getVariableName(),locale);
        }
        //替换${access_token}
        if (url.contains(TWAppUrlVariableEnum.ACCESS_TOKEN.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.ACCESS_TOKEN.getVariableName(), Utils.getUserToken());
        }
        return url;
    }


    /**
     * 获取三方系统的移动端作业地址
     *
     * @param appId
     * @param workCode
     * @return
     */
    private String getMobileJobUrl(String appId, String workCode) {
        LambdaQueryWrapper<SyncJobInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SyncJobInfo::getAppId, appId)
                .eq(SyncJobInfo::getJobCode, workCode);
        List<SyncJobInfo> syncJobInfos = syncJobInfoMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(syncJobInfos)) {
            return syncJobInfos.get(0).getJobUrl();
        }
        return "";
    }


    @Override
    public List<MobilePortalInfoContent> checkContentApp(List<Long> appIdList) {
        //查询 组件类型 3-金刚球、4：轮播图、6：标题、9：图片、10：业务入口）
        List<Integer> contentTypeList = new ArrayList<>();
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.TITLE.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.PICTURE.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal());
        List<MobilePortalInfoContent> mobilePortalInfoContents = mobilePortalInfoContentMapper.queryPortalContent(contentTypeList);
        for (MobilePortalInfoContent content : mobilePortalInfoContents) {
            //金刚球
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType())
                    && appIdList.contains(content.getCustomApplicationId())
            ) {
                return mobilePortalInfoContents;
            }
            //轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(content.getContentAttr(), MobilePortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty(carouselInfo.getImageList())) {
                    continue;
                }
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    //轮播图中引用了该应用作业
                    if (null != image.getJumpType() && image.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue())
                            && appIdList.contains(image.getCustomApplicationId())
                    ) {
                        return mobilePortalInfoContents;
                    }
                }
            }
            //标题组件
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(content.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                //标题组件中引用了该应用作业
                if (null != titleInfo
                        && null != titleInfo.getJumpType() &&
                        titleInfo.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue())
                        && appIdList.contains(titleInfo.getCustomApplicationId())
                ) {
                    return mobilePortalInfoContents;
                }
            }
            //图片
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null == imageCompInfo || CollectionUtils.isEmpty(imageCompInfo.getHotZoneList())) {
                    continue;
                }
                //图片组件中引用了该应用作业
                for (MobilePortalHotZoneReqDTO hotZone : imageCompInfo.getHotZoneList()) {
                    if (null != hotZone.getJumpType() &&
                            hotZone.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue())
                            && appIdList.contains(hotZone.getCustomApplicationId())
                    ) {
                        return mobilePortalInfoContents;
                    }
                }
            }
            //业务入口
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null == businessCompInfo || CollectionUtils.isEmpty(businessCompInfo.getImageList())) {
                    continue;
                }
                //业务入口组件中引用了该应用作业
                for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                    if (null != image.getJumpType() &&
                            image.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue())
                            && appIdList.contains(image.getCustomApplicationId())
                    ) {
                        return mobilePortalInfoContents;
                    }
                }
            }
        }
        return null;
    }

}
