package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.mobile.*;
import com.digiwin.athena.semc.service.mobile.MobileStartSetService;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class MobileStartSetServiceImpl extends ServiceImpl<MobileStartSetMapper, MobileStartSet>  implements MobileStartSetService {

    @Autowired
    private MobileStartSetMapper mobileStartSetMapper;

    @Resource
    private EnvProperties envProperties;

    @Override
    @Transactional
    public MobileStartSet saveStartSet(MobileStartSet startSet) {
        List<MobileStartSet> startSetList=selectStartSetList(startSet.getDeviceType());
        if(CollectionUtils.isEmpty(startSetList)){
            startSet.setTenantId(Utils.getTenantId());
            mobileStartSetMapper.insert(startSet);
        }else{
            mobileStartSetMapper.updateById(startSet);
        }
        //自定义图片
        if(StringUtils.isNotEmpty(startSet.getPicLocalId())){
            startSet.setPicLocalUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + startSet.getPicLocalId());
        }
        return startSet;
    }

    @Override
    public List<MobileStartSet> selectStartSetList(Integer deviceType) {
        List<MobileStartSet> startSetList=new ArrayList<>();
        QueryWrapper<MobileStartSet> condition = new QueryWrapper<MobileStartSet>();
        if(null !=deviceType){
            condition.eq("device_type",deviceType);
        }
        startSetList=mobileStartSetMapper.selectList(condition);
        for(MobileStartSet startSet:startSetList){
            //自定义图片
            if(StringUtils.isNotEmpty(startSet.getPicLocalId())){
                startSet.setPicLocalUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + startSet.getPicLocalId());
            }
             //模板库选择-简体
            if(StringUtils.isNotEmpty(startSet.getPicUrl())){
                startSet.setPicUrl(envProperties.getSemcWebUrl()+startSet.getPicUrl());
            }
            //模板库选择-繁体
            if(StringUtils.isNotEmpty(startSet.getPicUrlTw())){
                startSet.setPicUrlTw(envProperties.getSemcWebUrl()+startSet.getPicUrlTw());
            }
        }
        return startSetList;
    }
}
