package com.digiwin.athena.semc.service.mq.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.configuration.mqtt.MqttGateway;
import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class MessageSendServiceImpl implements MessageSendService {

    @Autowired
    private MqttGateway mqttGateway;

    @Autowired
    private MqttProperties mqttConfiguration;


    @Override
    public void sendToClient(String userId, MessageDO payload, String topicSuffix) {
        String message = JSONObject.toJSONString(payload);
        String topic = mqttConfiguration.getClientId() + "/" + mqttConfiguration.getServerName() + "/" + topicSuffix;
        log.info("【sendToClient-sendToClient发送消息开始】topic：{},message：{}", topic, message);
        mqttGateway.sendToMqtt(topic, 2, message);
        log.info("【sendToClient-sendToClient发送消息成功】topic：{},message：{}", topic, message);

    }

}
