package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.news.SaveNewsAuthReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.event.NewsAuthBizIdSetEvent;

import java.util.List;

/**
 * 新闻公告权限表(TNewsAnnouncementAuth)表服务接口
 *
 * @author sungqz
 * @since 2024-05-14
 */
public interface NewsAnnouncementAuthService extends IService<NewsAnnouncementAut> {

    /**
     * 保存公告的权限
     *
     * @param saveNewsAuthReq 入参
     * @return 返回
     */
    void saveNewsAuth(SaveNewsAuthReq saveNewsAuthReq);

    /**
     * 查询当前用户所属的公告id列表
     *
     * @return 返回
     */
    List<NewsAnnouncementAut> queryAuthNewsList();

    /**
     * 查询当前用户所属的公告id列表
     *
     * @return 返回
     */
    List<NewsAnnouncementAut> queryAuthNewsListByNewsTypeIdList(List<Long> newsTypeIdList);

    /**
     * 设置公告权限表的业务id
     * @param event 事件
     */
    void setNewsAuthBizId(NewsAuthBizIdSetEvent event);
}
