package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.news.MyNewsFavoritePageReq;
import com.digiwin.athena.semc.dto.news.NewsCommonIdListReq;
import com.digiwin.athena.semc.dto.news.NewsCommonIdReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementFavorite;
import com.digiwin.athena.semc.mq.dto.NewsCancelFavoriteMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsFavoriteMessageDTO;
import com.digiwin.athena.semc.vo.news.MyNewsAnnouncementFavoriteVO;

public interface NewsAnnouncementFavoriteService extends IService<NewsAnnouncementFavorite> {

    /**
     * 公告收藏
     * @return 0：表示收藏成功，1：表示重复收藏，2：公告不存在或者无权限，3：收藏失败
     */
    Integer favoriteNews(NewsCommonIdReq newsCommonIdReq);

    /**
     * 公告取消收藏
     * @return 0：表示取消收藏成功，1：表示没有收藏记录（失败），2：取消收藏失败
     */
    Integer cancelFavoriteNews(NewsCommonIdListReq newsCommonIdListReq);

    /**
     * 我的收藏列表
     */
    PageInfoResp<MyNewsAnnouncementFavoriteVO> myFavoriteNewsList(MyNewsFavoritePageReq myNewsFavoritePageReq);

    /**
     * 处理公告收藏
     */
    void handlerFavoriteNews(NewsFavoriteMessageDTO newsFavoriteMessageDTO);

    /**
     * 处理取消收藏
     */
    void handlerCancelFavoriteNews(NewsCancelFavoriteMessageDTO newsCancelFavoriteMessageDTO);
}
