package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.news.NewLikeReqDTO;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementLike;
import com.digiwin.athena.semc.mq.dto.NewsLikeMessageDTO;

public interface NewsAnnouncementLikeService extends IService<NewsAnnouncementLike> {

    /**
     * 公告点赞
     * @param newLikeReqDTO
     * @param likeFlag 是否是点赞操作
     * @return 对于点赞操作（0：表示点赞成功，1：表示重复点赞，2：公告不存在或者无权限），对于取消点赞操作（0：表示取消点赞成功，1：表示没有点赞记录，2：公告不存在或者无权限）
     */
    Integer like(NewLikeReqDTO newLikeReqDTO,boolean likeFlag);

    /**
     * 处理点赞事件
     * @param newsLikeMessageDTO
     */
    void handlerLikeEvent(NewsLikeMessageDTO newsLikeMessageDTO);
}