package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.news.AnnouncementIdReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementRead;

import java.util.List;
import java.util.Map;

/**
 * 新闻公告已读表(TNewsAnnouncementRead)表服务接口
 *
 * @author sungqz
 * @since 2024-05-15
 */
public interface NewsAnnouncementReadService extends IService<NewsAnnouncementRead> {

    /**
     * web端/移动端-读取公告，记录为已读公告
     *
     * @param announcementIdReq 入参
     */
    Boolean insertNews(AnnouncementIdReq announcementIdReq);

    /**
     * 根据公告id查询对应的已读数
     * @param newsIdList 公告id集合
     * @return
     */
    Map<Long,Long> queryReadCount(List<Long> newsIdList);
}
