package com.digiwin.athena.semc.service.news;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.news.NewsStatisticsReqDTO;
import com.digiwin.athena.semc.dto.news.QueryMobileNewsListPageReq;
import com.digiwin.athena.semc.dto.news.QueryNewsListPageReq;
import com.digiwin.athena.semc.dto.news.SaveAnnouncementReq;
import com.digiwin.athena.semc.dto.news.UpdateNewsStatusReq;
import com.digiwin.athena.semc.dto.news.WebQueryNewsListPageReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.event.SendNoticeEvent;
import com.digiwin.athena.semc.vo.file.FileInfoVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementStatisticsVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementVO;
import com.digiwin.athena.semc.vo.news.ValidateNewsVO;

import java.util.List;
import java.util.Map;

/**
 * 新闻公告表(TNewsAnnouncement)表服务接口
 *
 * @author sungqz
 * @since 2024-05-13
 */
public interface NewsAnnouncementService extends IService<NewsAnnouncement> {

    /**
     * 分页查询公告列表
     *
     * @param queryNewsListPageReq 查询参数
     * @return 返回
     */
    PageInfoResp<NewsAnnouncementVO> queryNewsListByPage(QueryNewsListPageReq queryNewsListPageReq);

    /**
     * 更新公告发布状态
     *
     * @param updateNewsStatusReq 入参
     * @param newsAnnouncementList 公告列表
     */
    void updatePublishStatus(UpdateNewsStatusReq updateNewsStatusReq, List<NewsAnnouncement> newsAnnouncementList);

    /**
     * 更新公告置顶状态
     *
     * @param id         主键id
     * @param toppedFlag 是否置顶 0:否 1:是
     */
    void updateToppedStatus(Long id, Integer toppedFlag);

    /**
     * 删除公告
     *
     * @param idList 公告id列表
     */
    void delNews(List<Long> idList);

    /**
     * 查询公告详情
     *
     * @param id 主键id
     * @return 返回
     */
    NewsAnnouncementVO queryManagerNewsDetail(Long id);

    /**
     * 保存公告
     *
     * @param saveAnnouncementReq 入参
     * @return 返回
     */
    void saveNews(SaveAnnouncementReq saveAnnouncementReq);

    /**
     * 前台分页查询用户公告列表
     *
     * @return 返回
     */
    PageInfoResp<NewsAnnouncementVO> queryUserNewsList(WebQueryNewsListPageReq webQueryNewsListPageReq);


    /**
     * 查询三方公告
     * @param newsTypeIdList
     */
    List<NewsAnnouncement> queryThirdNewsList(List<Long> newsTypeIdList);

    /**
     * web端/移动端-查询用户端公告详情
     *
     * @param newsAnnouncement 公告
     * @param  callSource 调用方：0或者空（移动端），1（web端）
     * @return 返回
     */
    NewsAnnouncementVO queryUserNewsDetail(NewsAnnouncement newsAnnouncement,Integer callSource);

    /**
     * 查询用户端公告详情，不包含附件
     *
     * @param id 主键id
     * @return 返回
     */
    NewsAnnouncement queryUserNewsById(Long id);


    /**
     * 移动端/web端-校验公告的是否存在/是否有效
     * @param id
     * @return
     */
    ValidateNewsVO validateNews(Long id);

    /**
     * 移动端/web端-校验公告的是否存在/是否有效
     * @param idList
     * @return
     */
    Map<Long, ValidateNewsVO> validateNews(List<Long> idList);

    /**
     * 查询用户的未读公告数
     *
     * @return 返回
     */
    Integer queryNewsUnReadCount();

    /**
     * 查询公告系统来源
     *
     * @return
     */
    public List<JSONObject> queryNewsAppList();

    /**
     * 移动端-前台分页查询用户公告列表
     *
     * @param queryMobileNewsListPageReq 请求参数
     * @return 查询结果
     */
    PageInfoResp<NewsAnnouncementVO> queryMobileNewsListPage(QueryMobileNewsListPageReq queryMobileNewsListPageReq);

    /**
     * 构建文件信息
     *
     * @param fileIdArray 文件id
     * @param fileIdMap   文件信息
     * @return 返回
     */
    List<FileInfoVO> buildDetailFileInfo(String[] fileIdArray, Map<String, Object> fileIdMap);

    /**
     * 查询当前租户移动端公告列表
     *
     * @return 查询结果
     */
    List<NewsAnnouncement> queryNewsListByCondition(QueryNewsListPageReq queryNewsListPageReq);


    NewsAnnouncementStatisticsVO queryManagerNewsStatistics(NewsStatisticsReqDTO newsStatisticsReqDTO);

    /**
     * 发送工作提醒
     *
     * @param event 发送工作提醒事件
     */
    void sendNewsNotice(SendNoticeEvent event);
}
