package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeAuthReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementTypeAuth;
import com.digiwin.athena.semc.vo.news.NewsTypeAuthVO;

/**
 * 公告类型权限表  表服务接口
 *
 * @author sungqz
 * @since 2025-01-10
 */
public interface NewsAnnouncementTypeAuthService extends IService<NewsAnnouncementTypeAuth> {

    /**
     * 管理后台-查询权限对象关联的公告类型
     *
     * @param authId 权限id
     * @return 返回
     */
    NewsTypeAuthVO queryAuthRelNewsType(String authId);

    /**
     * 管理后台-保存权限对象关联的公告类型
     *
     * @param saveNewsTypeAuthReq 请求入参
     */
    void saveNewsTypeAuth(SaveNewsTypeAuthReq saveNewsTypeAuthReq);
}
