package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeReqDTO;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import com.digiwin.athena.semc.event.NewsChangeEvent;

import java.util.List;

/**
 * 新闻公告类型表(TNewsAnnouncementType)表服务接口
 *
 * @author sungqz
 * @since 2024-05-13
 */
public interface NewsAnnouncementTypeService extends IService<NewsAnnouncementType> {

    /**
     * 查询公告类型
     *
     * @param id 公告类型id
     * @return 返回
     */
    List<NewsAnnouncementType> queryNewsTypeListByParentId(Long id);


    boolean existByTypeId(Long id);

    /**
     * 删除自定义类型
     *
     * @param newsAnnouncementType 公告类型
     */
    void delNewsType(NewsAnnouncementType newsAnnouncementType);

    /**
     * 保存公告类型
     *
     * @param saveNewsTypeReqDTO 请求入参
     * @return 返回
     */
    Boolean saveNewsType(SaveNewsTypeReqDTO saveNewsTypeReqDTO);

    /**
     * 保存公告类型的公告数
     *
     * @param event 公告类型变更事件
     */
    void saveNewsCount(NewsChangeEvent event);
}
